
 /*-------------------------------------------------------------*/
 /*---         Header for libbzip2                 bzlib.cpy ---*/
 /*---                                                       ---*/
 /*-------------------------------------------------------------*/

 /*--

  This is a PL/I port of the header file bzlib.h for libbzip2, 
  a library for lossless, block-sorting data compression.

  The orginal source is covered by the following copyright:
  Copyright (C) 1996-2002 Julian R Seward.  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. The origin of this software must not be misrepresented; you must 
     not claim that you wrote the original software.  If you use this 
     software in a product, an acknowledgment in the product 
     documentation would be appreciated but is not required.

  3. Altered source versions must be plainly marked as such, and must
     not be misrepresented as being the original software.

  4. The name of the author may not be used to endorse or promote 
     products derived from this software without specific prior written 
     permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  Julian Seward, Cambridge, UK.
  jseward@acm.org
  bzip2/libbzip2 version 1.0 of 21 March 2000

  This program is based on (at least) the work of:
     Mike Burrows
     David Wheeler
     Peter Fenwick
     Alistair Moffat
     Radford Neal
     Ian H. Witten
     Robert Sedgewick
     Jon L. Bentley

  For more information on these sources, see the manual.

  PL/I port by Peter Flass <Peter_Flass@Yahoo.com>, Feb, 2005

 --*/

 %declare BZ_RUN    character; 
 %declare BZ_FLUSH  character;
 %declare BZ_FINISH character; 
 %BZ_RUN    = '0';
 %BZ_FLUSH  = '1';
 %BZ_FINISH = '2';

 %declare BZ_OK               character; 
 %declare BZ_FLUSH_OK         character; 
 %declare BZ_FINISH_OK        character; 
 %declare BZ_STREAM_END       character; 
 %declare BZ_SEQUENCE_ERROR   character; 
 %declare BZ_PARAM_ERROR      character; 
 %declare BZ_MEM_ERROR        character; 
 %declare BZ_DATA_ERROR       character; 
 %declare BZ_DATA_ERROR_MAGIC character; 
 %declare BZ_IO_ERROR         character; 
 %declare BZ_UNEXPECTED_EOF   character; 
 %declare BZ_OUTBUFF_FULL     character; 
 %declare BZ_CONFIG_ERROR     character; 

 %BZ_OK               = '0';
 %BZ_RUN_OK           = '1';
 %BZ_FLUSH_OK         = '2';
 %BZ_FINISH_OK        = '3';
 %BZ_STREAM_END       = '4';
 %BZ_SEQUENCE_ERROR   = '-1';
 %BZ_PARAM_ERROR      = '-2';
 %BZ_MEM_ERROR        = '-3';
 %BZ_DATA_ERROR       = '-4';
 %BZ_DATA_ERROR_MAGIC = '-5';
 %BZ_IO_ERROR         = '-6';
 %BZ_UNEXPECTED_EOF   = '-7';
 %BZ_OUTBUFF_FULL     = '-8';
 %BZ_CONFIG_ERROR     = '-9';

 declare 1 bz_stream         based,
           5 next_in         pointer,
           5 avail_in        unsigned fixed binary(31),
           5 total_in_lo32   unsigned fixed binary(31),
           5 total_in_hi32   unsigned fixed binary(31),

           5 next_out        pointer,
           5 avail_out       unsigned fixed binary(31),
           5 total_out_lo32  unsigned fixed binary(31),
           5 total_out_hi32  unsigned fixed binary(31),

           5 state           pointer,

           5 bzalloc         pointer,
           5 bzfree          pointer,
           5 opaque          pointer;


 /*-- Core (low-level) library functions --*/
 declare BZ2_bzCompressInit  entry( pointer,           /* addr(strm) */
                                    fixed binary(31),  /* blockSize100k */
                                    fixed binary(31),  /* verbosity */
                                    fixed binary(31) ) /* workFactor */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzCompressInit' )
                             returns( fixed binary(31) );
 declare BZ2_bzCompress      entry( pointer,           /* addr(strm) */
                                    fixed binary(31) ) /* action */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzCompress' )
                             returns( fixed binary(31) );
 declare BZ2_bzCompressEnd   entry( pointer )          /* addr(strm) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzCompressEnd' )
                             returns( fixed binary(31) );
 declare BZ2_bzDecompressInit entry( pointer,          /* addr(strm) */
                                    fixed binary(31),  /* verbosity */
                                    fixed binary(31) ) /* small */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzDecompressInit' )
                             returns( fixed binary(31) );
 declare BZ2_bzDecompress    entry( pointer )          /* addr(strm) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzDecompress' )
                             returns( fixed binary(31) );
 declare BZ2_bzDecompressEnd entry( pointer )          /* addr(strm) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzDecompressEnd' )
                             returns( fixed binary(31) );                          


 /*-- High(er) level library functions --*/


 declare BZ2_bzReadOpen      entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(f) */
                                    fixed binary(31),  /* verbosity */
                                    fixed binary(31),  /* small */
                                    pointer,           /* addr(unused) */
                                    fixed binary(31) ) /* nUnused */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzReadOpen' )
                             returns( pointer );       /* addr(BZFILE) */
 declare BZ2_bzReadClose     entry( pointer,           /* addr(bzerror) */
                                    pointer )          /* addr(b) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzReadClose' );
 declare BZ2_bzReadGetUnused entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(b) */
                                    pointer,           /* addr(addr(unused)) */
                                    pointer )          /* addr(nUnused) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzReadGetUnused' );
 declare BZ2_bzRead          entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(b) */
                                    pointer,           /* addr(buf) */
                                    fixed binary(31) ) /* len */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzRead' );
 declare BZ2_bzWriteOpen     entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(f) */
                                    fixed binary(31),  /* verbosity */
                                    fixed binary(31) ) /* workFactor */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzWriteOpen' )
                             returns( pointer );       /* addr(BZFILE) */
 declare BZ2_bzWrite         entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(b) */
                                    pointer,           /* addr(buf) */
                                    fixed binary(31) ) /* len */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzWrite' );
 declare BZ2_bzWriteClose    entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(b) */
                                    fixed binary(31),  /* abandon */
                                    pointer,           /* addr(nbytes_in) */
                                    pointer )          /* addr(nbytes_out) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzWriteClose' );
 declare BZ2_bzWriteClose64  entry( pointer,           /* addr(bzerror) */
                                    pointer,           /* addr(b) */
                                    fixed binary(31),  /* abandon */
                                    pointer,           /* addr(nbytes_in_lo32) */
                                    pointer,           /* addr(nbytes_in+hi32) */
                                    pointer,           /* addr(nbytes_out_lo32) */
                                    pointer )          /* addr(nbytes_out_hi32) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzWriteClose64' );


 /*-- Utility functions --*/

 declare BZ2_bzBuffToBuffCompress entry( pointer,      /* addr(dest) */
                                    pointer,           /* addr(destLen) */
                                    pointer,           /* addr(source) */
                                    fixed binary(31),  /* sourceLen */
                                    fixed binary(31),  /* blockSize100k */
                                    fixed binary(31),  /* verbosity */
                                    fixed binary(31) ) /* workFactor */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzBuffToBuffCompress' )
                             returns( fixed binary(31) );
 declare BZ2_bzBuffToBuffDecompress entry( pointer,    /* addr(dest) */
                                    pointer,           /* addr(destLen) */
                                    pointer,           /* addr(source) */
                                    fixed binary(31),  /* sourceLen */
                                    fixed binary(31),  /* small */
                                    fixed binary(31) ) /* verbosity */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzBuffToBuffDecompress' )
                             returns( fixed binary(31) );

 /*--
    Code contributed by Yoshioka Tsuneo
    (QWF00133@niftyserve.or.jp/tsuneo-y@is.aist-nara.ac.jp),
    to support better zlib compatibility.
    This code is not _officially_ part of libbzip2 (yet);
    I haven't tested it, documented it, or considered the
    threading-safeness of it.
    If this code breaks, please contact both Yoshioka and me.
 --*/

 declare BZ2_bzlibVersion    entry
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzlibVersion' )
                             returns( pointer );

 %declare BZ_NO_STDIO character;
 %BZ_NO_STDIO = 'N';
 %if BZ_NO_STDIO = 'N' %then %goto #NO_STDIO;

 %declare BZ_MAX_UNUSED character;
 %BZ_MAX_UNUSED = '5000';

 declare BZ2_bzopen          entry( pointer,           /* addr(path) */
                                    pointer )          /* addr(mode) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzopen' )
                             returns( pointer );       /* addr(BZFILE) */
 declare BZ2_bzdopen         entry( fixed binary(31),  /* fd */
                                    pointer )          /* addr(mode) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzdopen' )
                             returns( pointer );       /* addr(BZFILE) */

 /* For some stupid reason, both BZ2_bzread and BZ2_bzRead are defined */
 /* rather than force case-sensitivity on the whole program, we'll     */
 /* redefine read and write as BZ2$bzread and BZ2$bzwrite.             */
 declare BZ2$bzread          entry( pointer,           /* addr(b) */
                                    pointer,           /* addr(buf) */
                                    fixed binary(31) ) /* len */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzread' )
                             returns( fixed binary(31) );
 declare BZ2$bzwrite         entry( pointer,           /* addr(b) */
                                    pointer,           /* addr(buf) */
                                    fixed binary(31) ) /* len */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzwrite' )
                             returns( fixed bin(31) );       
 declare BZ2_bzflush         entry( pointer )          /* addr(b) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzflush' )
                             returns( fixed bin(31) );       
 declare BZ2_bzfclose        entry( pointer )          /* addr(b) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzfclose' )
                             returns( fixed bin(31) );       
 declare BZ2_bzerror         entry( pointer,           /* addr(b) */
                                    pointer )          /* addr(errnum) */
                             options( byvalue linkage(system) )
                             ext( 'BZ2_bzerror' )
                             returns( pointer );    

 %#NO_STDIO: ;

 /*-------------------------------------------------------------*/
 /*--- end                                         bzlib.cpy ---*/
 /*-------------------------------------------------------------*/
