 /*------------------------------------------------------------------*/
 /* REXX-like 'words()' function.                                    */
 /*------------------------------------------------------------------*/

 words: procedure(str) options( reentrant )
                         returns( fixed binary(5) );

 dcl  str                    char(*) varying;
 dcl (s,e,i,n)               fixed bin(15)       init(0);

 i=1;
 do while('1'b);
   s=find_start(str,i);
   if s=0 then return(n);
   n=n+1;
   i=s;
   e=find_end(str,i);
   i=e;
   end; /* do while */

 find_start: proc(s,p) options( reentrant )
                       returns( fixed bin(15) );
   dcl s                     char(*) varying;
   dcl p                     fixed bin(15);
   dcl j                     fixed bin(15);
   do j=p to length(s);
     if substr(str,j,1)^=' ' then return(j);
     end;
   return(0);
   end find_start;

 find_end: proc(s,p) options( reentrant )
                     returns( fixed bin(15) );
   dcl s                     char(*) varying;
   dcl p                     fixed bin(15);
   dcl j                     fixed bin(15);
   do j=p to length(s);
     if substr(str,j,1)=' ' then return(j);
     end;
   return( length(s)+1 );
   end find_end;

 end words;
