         TITLE 'STARTUP AND CLOSEDOWN'                                  ZPL00010
ZPLT     CSECT                                                          ZPL00020
         SAVE  (14,12)        SAVE REGS                                 ZPL00030
         BALR  12,0                                                     ZPL00040
         USING *,12                                                     ZPL00050
         SR    15,15                                                    ZPL00060
         ST    15,16(13)           CLEAR RET CD                         ZPL00070
         LA    15,SAV                                                   ZPL00080
         ST    15,8(13)            CHAIN SAS                            ZPL00090
         ST    13,4(15)                                                 ZPL00100
         LR    13,15               -> SAVE AREA                         ZPL00110
         L     2,0(,1)        SAVE PARM ADDRESS                         ZPL00120
         LA    2,0(2)         CLEAR TOP BYTE                            ZPL00130
*                                                                       ZPL00140
         TIME  BIN            GET TIME                                  ZPL00150
         ST    0,TIMEIN       AND SAVE IT                               ZPL00160
         STIMER  TASK,DUMEXIT,TUINTVL=DUMINTVL                          ZPL00170
         OPEN    (DCBOUT,(OUTPUT))                                      ZPL00180
*                                                                       ZPL00190
         SR    10,10                IND NO LIBRARY DCB SPECIFIED YET    ZPL00200
*                                                                       ZPL00210
*                   PROCESS INPUT PARM LIST                             ZPL00220
*                                                                       ZPL00230
         SR    4,4            R4 TO ZERO - COUNT OF PARM LENGTH         ZPL00240
         LA    5,2(,2)        POINT AT BEGINNING OF PARM                ZPL00250
         LH    3,0(,2)        GET PARM COUNT                            ZPL00260
         LTR   3,3            ANY PARMS                                 ZPL00270
         BZ    NOPARM         NO - USE DEFAULTS                         ZPL00280
CHECKNXT CLI   0(5),C','      COMMA                                     ZPL00290
         BE    PARM1          YES - PARM1 FOUND                         ZPL00300
         LA    4,1(,4)        UPDATE COUNT OF FIRST PARM                ZPL00310
         LA    5,1(,5)        POINT AT NEXT CHAR                        ZPL00320
         BCT   3,CHECKNXT     GO CHECK IT                               ZPL00330
*                                                                       ZPL00340
*       DROPPED OUT - RUN OUT OF CHARS TO CHECK - TAKE WHAT             ZPL00350
*               WE HAVE AS FIRST PARM                                   ZPL00360
*                                                                       ZPL00370
PARM1    LTR   4,4            DID WE GET ANYTHING,                      ZPL00380
         BZ    NOPARM1                                                  ZPL00390
         LR    1,5                                                      ZPL00400
         BCTR  1,0                   LAST CHAR OF NAME                  ZPL00410
         CLI   0(1),C')'             BRACKETS ?                         ZPL00420
         BNE   NODD                  N                                  ZPL00430
         LR    1,2                   Y. NAME IS IN FORM DDNAME(MEMBER)  ZPL00440
         LR    0,4                                                      ZPL00450
         BCTR  4,0                 LOSE COUNT FOR ')'                   ZPL00460
DDLP     CLI   2(2),C'('           LOOK FOR START OF (MEM)              ZPL00470
         BE    DDFND                                                    ZPL00480
         LA    2,1(2)                                                   ZPL00490
         BCT   0,DDLP                                                   ZPL00500
         LR    2,1                 NOT FOUND. POINT BACK TO START       ZPL00510
         B     NODD                                                     ZPL00520
MVDD     MVC   LIBRARY+40(0),2(1)      INSTR FOR EXECUTE                ZPL00530
DDFND    LR    15,2                                                     ZPL00540
         LA    2,1(2)                  LOSE '('                         ZPL00550
         BCTR  4,0                     DECR COUNT                       ZPL00560
         SR    15,1                    L'DDNAME                         ZPL00570
         BNH   NODD                                                     ZPL00580
         SR    4,15                    ADJUST MEMBER NAME LENGTH        ZPL00590
         CH    15,*+10                 LIMIT DDNAME TO 8 CHARS          ZPL00600
         BNH   *+8                                                      ZPL00610
         LA    15,8                                                     ZPL00620
         BCTR  15,0                     DECR FOR EX                     ZPL00630
         EX    15,MVDD                MOVE DDNAME TO DCB                ZPL00640
         OPEN  LIBRARY                                                  ZPL00650
         TM    LIBRARY+48,X'10'       OPEN OK ?                         ZPL00660
         BZ    NODD                                                     ZPL00670
*                                                                       ZPL00680
         LA    10,LIBRARY          ALL OK. INDICATE PRIVATE LIBRARY     ZPL00690
*                                                                       ZPL00700
NODD     LTR   4,4                                                      ZPL00710
         BNH   NOPARM1                                                  ZPL00720
         C     4,F8           MORE THAN EIGHT                           ZPL00730
         BNH   MOVE1          NO - PLACE COUNT IN MOVE INSTRUCTION      ZPL00740
         LA    7,MSGA         LOAD TRUNC WARNING MSG                    ZPL00750
         BAL   11,WTOMSG      GO ISSUE WARNING                          ZPL00760
         B     MV             GO MOVE EIGHT ONLY                        ZPL00770
MOVE1    BCTR  4,0            SUBTRACT ONE (FOR MVC)                    ZPL00780
         STC   4,MV+1         AND PUT IN MVC INST                       ZPL00790
MV       MVC   NAME(8),2(2)   STORE MOD NAME                            ZPL00800
NOPARM1  EQU   *                                                        ZPL00810
         BCTR  3,0                 ADJUST LEN FOR COMMA                 ZPL00820
         LTR   3,3            WAS THAT ALL                              ZPL00830
         BNH   NOPARM                                                   ZPL00840
         LA    5,1(,5)        POINT AT BEGINNING OF 2ND PARM            ZPL00850
         SR    4,4                                                      ZPL00860
         LR    1,5                                                      ZPL00870
CPULOOP  CLI   0(1),C','                                                ZPL00880
         BE    PARM2                                                    ZPL00890
         LA    4,1(4)                                                   ZPL00900
         LA    1,1(1)                                                   ZPL00910
         BCT   3,CPULOOP                                                ZPL00920
PARM2    LTR   4,4                                                      ZPL00930
         BZ    NOPARM2                                                  ZPL00940
         C     4,F8                                                     ZPL00950
         BNH   MOVE2          NO - GO PUT LENGTH INTO MVC               ZPL00960
         LA    7,MSGB         YES - POINT TO TRUNCATION WARNING         ZPL00970
         BAL   11,WTOMSG      GO ISSUE WARNING                          ZPL00980
         B     MV2            GO MOVE EIGHT ONLY                        ZPL00990
MOVE2    BCTR  4,0                                                      ZPL01000
         STC   4,MV2+1                                                  ZPL01010
         OI    MV2+1,X'70'                                              ZPL01020
         STC   4,MV2B+1                                                 ZPL01030
         LA    4,1(4)                                                   ZPL01040
MV2      PACK  PESTCPU(8),0(8,5)       CVT EST CPU TIME TO DEC          ZPL01050
MV2B     MVC   ESTCPU,0(5)                                              ZPL01060
VALOOP   CLI   0(5),C'0'           VALID DIGIT ?                        ZPL01070
         BL    ERRVAL              N                                    ZPL01080
         CLI   0(5),C'9'                                                ZPL01090
         BH    ERRVAL                                                   ZPL01100
         LA    5,1(5)                                                   ZPL01110
         BCT   4,VALOOP                                                 ZPL01120
         B     OKVAL                                                    ZPL01130
ERRVAL   AR    5,4                 R5 -> COMMA AFTER PARM               ZPL01140
         MVC   EAREA(8),ESTCPU                                          ZPL01150
         LA    7,MSGC              TRUNC MSG                            ZPL01160
         BAL   11,WTOMSG                                                ZPL01170
         B     NOPARM2                                                  ZPL01180
OKVAL    CVB   15,PESTCPU                                               ZPL01190
         M     14,F384             TIMER UNITS/100                      ZPL01200
         D     14,F80                                                   ZPL01210
         CH    15,*+10             INTERVAL TOO SMALL (OR ZERO) ?       ZPL01220
         BH    *+8                 N. OK                                ZPL01230
         LA    15,144              MIN VALUE (=30 SEC EST CPU TIME)     ZPL01240
         ST    15,TRCINTVL                                              ZPL01250
NOPARM2  BCTR  3,0                                                      ZPL01260
         LTR   3,3                                                      ZPL01270
         BNH   NOPARM                                                   ZPL01280
         LA    5,1(5)                                                   ZPL01290
         C     3,F100                                                   ZPL01300
         BNH   MOVE3                                                    ZPL01310
         LA    7,MSGD                                                   ZPL01320
         BAL   11,WTOMSG                                                ZPL01330
         LA    3,100                                                    ZPL01340
MOVE3    STH   3,LEN                                                    ZPL01350
         BCTR  3,0                                                      ZPL01360
         STC   3,MV3+1                                                  ZPL01370
MV3      MVC   TEXT,0(5)                                                ZPL01380
         B     LOADIT         GO TO LOAD MODULE                         ZPL01390
         EJECT                                                          ZPL01400
*                                                                       ZPL01410
*         DAVS  CONSTANTS AND CLOSED ROUTINES                           ZPL01420
*                                                                       ZPL01430
WTOMSG   MVC   WTPMAC+8(80),0(7)    MSG INTO WTO AREA                   ZPL01440
WTPMAC   WTO   '1234567890123456789012345678901234567890123456789012345*ZPL01450
               6789012345678901234567890',ROUTCDE=11                    ZPL01460
         BR    11             RETURN                                    ZPL01470
*                                                                       ZPL01480
*       CONSTANTS ETC                                                   ZPL01490
*                                                                       ZPL01500
MSGA     DC    CL80'MODULE NAME TRUNCATED TO 8 CHARS ***'               ZPL01510
MSGB     DC    CL80'ESTIMATED CPU TOO BIG FIRST 8 CHARS ONLY USED***'   ZPL01520
MSGC     DC    CL80' ''        ''  NOT NUMERIC  - IGNORED'              ZPL01530
EAREA    EQU   MSGC+2                                                   ZPL01540
MSGD     DC    CL80'EXEC PARM TRUNCATED TO 100 CHARS'                   ZPL01550
PARM     DS    0F                                                       ZPL01560
         DC    X'80',AL3(LEN)                                           ZPL01570
LEN      DC    H'0'                                                     ZPL01580
TEXT     DC    CL100'DUMMY EXEC PARAMETER'                              ZPL01590
         DS    0D                                                       ZPL01600
ESTCPU   DC    CL8' '                                                   ZPL01610
PESTCPU  DC    8CL1'0'                                                  ZPL01620
F8       DC    F'8'                                                     ZPL01630
F80      DC    F'80'                                                    ZPL01640
F100     DC    F'100'                                                   ZPL01650
F384     DC    F'384'              CVT FACTOR TO TU/100                 ZPL01660
DAVFLAG  DC    X'00'                                                    ZPL01670
         EJECT                                                          ZPL01680
         DS    0H                                                       ZPL01690
NOPARM   EQU   *                                                        ZPL01700
LOADIT   BLDL  (10),BLDL           BLDL FOR PL/1 MODULE                 ZPL01710
         LTR   15,15                   BLDL OK                          ZPL01720
         BZ    BLDLOK                  YES                              ZPL01730
         MVC   WTO1+30(8),NAME                                          ZPL01740
WTO1     WTO   'ERROR LOADING PROGRAM XXXXXXXX'                         ZPL01750
         ABEND 999,DUMP                                                 ZPL01760
BLDLOK   EQU   *                                                        ZPL01770
         LA    8,NAME                                                   ZPL01780
         BAL   9,SSI               CHECK FOR OPTIMISER                  ZPL01790
         MVI   OPT,C'F'            NO.                                  ZPL01800
         LOAD  DE=NAME,DCB=(10)                                         ZPL01810
         MVC   WRD1,=C'STRT'                                            ZPL01820
         MVC   WRD4,TRCINTVL                                            ZPL01830
         MVC   WRD5(8),NAME                                             ZPL01840
         TTIMER CANCEL                                                  ZPL01850
         ST    0,TIMELEFT                                               ZPL01860
         STIMER   TASK,EXIT,TUINTVL=TRCINTVL                            ZPL01870
         LA    1,PARM                                                   ZPL01880
         LINK  DE=NAME,DCB=(10)                                         ZPL01890
*                                                                       ZPL01900
         L     14,4(13)            -> HIGH SA                           ZPL01910
         ST    15,16(14)           ST RET CD                            ZPL01920
         TTIMER CANCEL        PROGRAM FINISHED - TIDY UP                ZPL01930
         TM    DAVFLAG,X'FF'  ALREADY INDICATED END                     ZPL01940
         BO    NOENDRQ        YES BYPASS END RECORD                     ZPL01950
         MVC   WRD1,=CL4'END'                                           ZPL01960
         L     4,DUMINTVL                                               ZPL01970
         S     4,TIMELEFT                                               ZPL01980
         A     4,TOTTIME                                                ZPL01990
         ST    4,WRD3                                                   ZPL02000
         MVC   WRD4,TIMEIN                                              ZPL02010
         TIME  BIN                                                      ZPL02020
         ST    0,WRD5                                                   ZPL02030
         PUT   DCBOUT,BUFFER                                            ZPL02040
*                                                                       ZPL02050
NOENDRQ  CLOSE (DCBOUT,,LIBRARY)                                        ZPL02060
*                                                                       ZPL02070
         L     13,4(13)            HI SA                                ZPL02080
         LM    14,12,12(13)        REST REGS AND RET CD                 ZPL02090
         BR    14                                                       ZPL02100
         TITLE 'SCAN SSI BYTES FOR OPTIMISER FLAG'                      ZPL02110
SSI      TM    32(8),X'80'         VS LOAD MODULE ?                     ZPL02120
         BO    VSMOD               Y                                    ZPL02130
*                                                                       ZPL02140
         IC    15,13(8)            COUNT BYTE                           ZPL02150
         LA    0,31                                                     ZPL02160
         NR    15,0             CLEAR FLAG AND TTRS                     ZPL02170
         AR    15,15               USER DATA LENGTH                     ZPL02180
         LA    14,LENS                                                  ZPL02190
         LA    0,4                                                      ZPL02200
CFSSI    CH    15,0(14)            LENGTH FOUND ?                       ZPL02210
         BE    LSSI                      YES                            ZPL02220
         LA    14,2(14)            NEXT LENGTH                          ZPL02230
         BCT   0,CFSSI                                                  ZPL02240
         BR    9           NO SSI SO NOT OPTIMISER                      ZPL02250
*                                                                       ZPL02260
LENS     DC    Y(26,36,34,44)      LENGTHS FOR OS SSI ENTRIES           ZPL02270
*                                                                       ZPL02280
VSMOD    TM    32(8),X'10'         SSI PRESENT                          ZPL02290
         BZ    4(9)                N. OUT                               ZPL02300
***      BCR   8,9                 N. OUT *** REPLACED BY ABOVE ***     ZPL02310
         LA    15,26               NORMAL SSI END                       ZPL02320
         TM    22(8),X'04'         SCTR ATTRIB ?                        ZPL02330
         BZ    *+8                 N                                    ZPL02340
         LA    15,8(15)            Y. INCR OFFSET                       ZPL02350
         TM    13(8),X'80'         ALIAS ?                              ZPL02360
         BZ    *+8                 N                                    ZPL02370
         LA    15,10(15)           Y. INCR OFFSET                       ZPL02380
LSSI     LA    14,10(15,8)        -> SSI BYTES                          ZPL02390
         TM    2(14),X'30'         OPTIMISER/CHECKER ?                  ZPL02400
         BNZ   4(9)                Y                                    ZPL02410
         BR    9                            NO                          ZPL02420
         TITLE 'TRACE EXIT ROUTINE'                                     ZPL02430
EXIT     EQU   *                                                        ZPL02440
         SAVE  (14,12)                                                  ZPL02450
         BALR  12,0                                                     ZPL02460
         USING *,12                                                     ZPL02470
         ST    13,SAV2+4                                                ZPL02480
         LA    13,SAV2                                                  ZPL02490
         STIMER TASK,DUMEXIT,TUINTVL=DUMINTVL                           ZPL02500
         SPIE  SPIEXIT,((1,8))                                          ZPL02510
**       SPIE  SPIEXIT,(9)         DUMMY                                ZPL02520
         ST    1,PICA                                                   ZPL02530
         L     2,COUNT                                                  ZPL02540
         A     2,=F'1'                                                  ZPL02550
         ST    2,COUNT                                                  ZPL02560
         C     2,CNTLIMIT                                               ZPL02570
         BE    DAVTERM        GO PUT END RECORD NOW                     ZPL02580
*                             THIS WILL INDICATE WHETHER ESTIMATED      ZPL02590
*                             CPU WAS REASONABLY ACCURATE OR NOT        ZPL02600
FIRST    BC    0,NOTFIRST                                               ZPL02610
         MVI   MODSCNB+1,X'0A' SET FIRST MOD SCAN FOR 10 TH INTERRUPT   ZPL02620
         L     2,16           CVT                                       ZPL02630
         L     2,0(,2)        TCB POINTER                               ZPL02640
         L     2,4(2)              TCB                                  ZPL02650
         LA    2,0(,2)        CLEAR HIGH-ORDER BYTE                     ZPL02660
         ST    2,TCBAD        STORE TCB ADDRESS                         ZPL02670
         L     3,0(,2)        MY RB                                     ZPL02680
         LA    9,100               LOOP COUNT                           ZPL02690
LOOKCDE  L     3,28(,3)       NEXT RB                                   ZPL02700
         L     4,12(,3)       CDE AD                                    ZPL02710
         CLC   8(8,4),NAME    IS IT OUR RB                              ZPL02720
         BE    FINDCDE        YES                                       ZPL02730
         BCT   9,LOOKCDE      NO - LOOK AT NEXT                         ZPL02740
         BAL   10,ERROR01     TOO MANY - ERROR                          ZPL02750
FINDCDE  LA    3,0(,3)        CLEAR HIGH-ORDER BYTE                     ZPL02760
         ST    3,PRBAD        STORE PRB ADDRESS                         ZPL02770
         PUT   DCBOUT,BUFFER                                            ZPL02780
         XC    WRD4,WRD4                                                ZPL02790
         OI    FIRST+1,X'F0'       SET 1ST TIME SW NOW                  ZPL02800
         SPACE 3                                                        ZPL02810
NOTFIRST EQU   *                                                        ZPL02820
***  R2   TCB AD                                                        ZPL02830
***  R3   SCAN RB                                                       ZPL02840
***  R4   PREV RB                                                       ZPL02850
***  R5   AD LEAST ACTIVE RB WITH A SAVE AREA                           ZPL02860
         XC    WRD1+3(1),WRD1+3   CLEAR                                 ZPL02870
         SR    0,0                                                      ZPL02880
         ST    0,WRD4              ZERO WRD 4                           ZPL02890
         BCTR  0,0                                                      ZPL02900
         BCTR  0,0                                                      ZPL02910
         ST    0,WRD3              AND SET WRD3 TO STMT NOT FND         ZPL02920
         LA    9,100               LOOP COUNT                           ZPL02930
         L     2,TCBAD                                                  ZPL02940
         L     3,0(,2)        RB AD                                     ZPL02950
         LR    4,3                                                      ZPL02960
         LR    5,3            IRB DOESNT HAVE FLAGS                     ZPL02970
SCANCHN  LA    3,0(3)              CLEAR HIGH BYTE                      ZPL02980
         TM    10(4),X'E0'             IS IT PRB ?                      ZPL02990
         BZ    *+6                     Y. DONT USE THESE REGS           ZPL03000
         LR    5,4            SAVE RB AD W/ SA                          ZPL03010
         C     3,PRBAD        IS IT LINKED TO PRB                       ZPL03020
         BE    FOUND          YES                                       ZPL03030
         LR    4,3                                                      ZPL03040
         L     3,28(,4)       NEXT RB FROM RB                           ZPL03050
         BCT   9,SCANCHN      CHECK NEXT                                ZPL03060
         BAL   10,ERROR02                                               ZPL03070
         SPACE 3                                                        ZPL03080
FOUND    EQU   *                                                        ZPL03090
***  R3   AD LINKED RB                                                  ZPL03100
***  R4   AD NEXT RB                                                    ZPL03110
***  R5   AD LEAST ACTIVE RB WITH A SAVE AREA                           ZPL03120
         L     15,28(5)            LOWEST NON-SAVE AREA RB              ZPL03130
         MVC   WRD2,20(15)         PSW ADDR                             ZPL03140
         MVI   WRD2,X'00'     CLEAR ADDR PSW HIGH ORDER                 ZPL03150
         MVC   WRD4+3(1),19(3)  INTERRUPT CODE                          ZPL03160
         TM    17(3),X'08'         BC MODE PSW ?                        ZPL03170
         BZ    NOTEC               Y. OK                                ZPL03180
         LR    15,3                EC MODE -> RB                        ZPL03190
         BCTR  15,0                MINUS ONE                            ZPL03200
         MVC   WRD4+3(1),0(15)     MV INTERRUPT CODE                    ZPL03210
NOTEC    EQU   *                                                        ZPL03220
*    LOOK FOR STATEMENT NUMBER                                          ZPL03230
         LA    9,100               LOOP COUNT                           ZPL03240
***  R6   R13  SAVE AREA                                                ZPL03250
         L     6,84(,5)       R13 FROM XRB SA                           ZPL03260
         CLI   OPT,C'O'            OPTIMISER ?                          ZPL03270
         BE    PLOPT               Y                                    ZPL03280
*                                  STATEMENT NO. FOR PL/1 F             ZPL03290
         L     8,76(5)             R11 FROM RB SA                       ZPL03300
         NI    EXTF+1,X'0F'                                             ZPL03310
SCAN13   LA    6,0(6)              CLEAR HI BYTE                        ZPL03320
         CLI   0(6),X'29'     PRV VDA                                   ZPL03330
         BE    QUITSCAN       YES                                       ZPL03340
         C     6,=A(SAV)           OUR SAVE AREA ?                      ZPL03350
         BE    QUITSCAN       YES                                       ZPL03360
         TM    0(6),X'80'     IS IT DSA                                 ZPL03370
         BO    STMT           YES                                       ZPL03380
         L     6,4(,6)        CHAIN BACK                                ZPL03390
         L     8,64(6)             SAVED R11                            ZPL03400
         BCT   9,SCAN13       CHECK NEXT                                ZPL03410
**       BAL   10,ABEND                                                 ZPL03420
         B     QUITSCAN       NO STMT FOUND                             ZPL03430
STMT     EQU   *                                                        ZPL03440
         TM    0(6),X'40'     STMT OPTION FLAG                          ZPL03450
         BO    MVSTMT         ON - GET STMT NUMBER                      ZPL03460
         SR    0,0                                                      ZPL03470
         BCTR  0,0                                                      ZPL03480
         ST    0,WRD3              SET DUMMY STMT NO.                   ZPL03490
         B     NOMVST         BYPASS STMT NO MOVE                       ZPL03500
MVSTMT   L     0,96(6)             STMT NO.                             ZPL03510
         SLA   0,5                 ADD 5 ZERO BITS TO CONFORM WITH LNNO ZPL03520
         ST    0,WRD3                                                   ZPL03530
NOMVST   LA    9,100                LOOP COUNT                          ZPL03540
BEGLP    TM    0(6),X'E0'              BEGIN BLOCK ?                    ZPL03550
         BNO   BACKSAV        NO - BACK A SAVE AREA                     ZPL03560
         L     6,4(,6)        BACK EXTRA SA IF BEGIN BLOCK              ZPL03570
         BCT   9,BEGLP                                                  ZPL03580
         B     QUITSCAN                                                 ZPL03590
BACKSAV  L     6,4(,6)        BACK ONE SA                               ZPL03600
         LA    9,100                                                    ZPL03610
VDALOOP  CLI   0(6),X'29'     PRV VDA                       VDA MOD     ZPL03620
         BE    MPROC          YES                           VDA MOD     ZPL03630
         TM    0(6),X'80'     PROC DSA                      VDA MOD     ZPL03640
         BO    NOTMPROC       YES                           VDA MOD     ZPL03650
         TM    0(6),X'60'     LIB DSA                       VDA MOD     ZPL03660
         BO    NOTMPROC       YES                           VDA MOD     ZPL03670
         L     6,4(,6)        A VDA - CHAIN BACK FOR SA     VDA MOD     ZPL03680
         BCT   9,VDALOOP                                                ZPL03690
         B     QUITSCAN                                                 ZPL03700
MPROC    OI    WRD1+3,X'80'   INDICATE MAIN PROC            VDA MOD     ZPL03710
LOSEPRV  L     6,4(6)              BACK A SA FOR PRV VDA                ZPL03720
NOTMPROC L     15,16(6)            SAVED R15                            ZPL03730
         SR    7,7                                                      ZPL03740
         IC    7,4(15)             L'NAME                               ZPL03750
         BCTR  7,0                                                      ZPL03760
         CH    7,*+10              LENGTH > 8 ?                         ZPL03770
         BNH   *+8                                                      ZPL03780
         LA    7,7                 MAX 8 CHARS                          ZPL03790
         MVC   WRD5(8),=CL8' ' CLEAR                                    ZPL03800
         LTR   7,7                 LENGTH NEGATIVE ?                    ZPL03810
         BL    EXTF                Y. NO NAME                           ZPL03820
         EX    7,MOVEPROC     MOVE PROC NAME                            ZPL03830
EXTF     NOP   QUITSCAN            ALT B AND NOP                        ZPL03840
         OI    *-3,X'F0'                                                ZPL03850
         MVC   WRD7(8),WRD5        MV PROC NAME                         ZPL03860
         TM    WRD1+3,X'80'         MAIN PROC ?                         ZPL03870
         BO    QUITSCAN            Y                                    ZPL03880
         LA    9,100               LOOP COUNT                           ZPL03890
EXTFLP   C     8,64(6)             SAME STATIC CSECT ?                  ZPL03900
         BE    OUTER               Y. BACK TO CONTAINING PROC SA        ZPL03910
         CLI   0(6),X'29'          PRV ?                                ZPL03920
         BE    LOSEPRV             Y. BACK A SA AND GET NAME            ZPL03930
         TM    0(6),X'80'          PROC ?                               ZPL03940
         BO    NOTMPROC            Y                                    ZPL03950
         TM    0(6),X'60'          LIB DSA ?                            ZPL03960
         BO    NOTMPROC            Y                                    ZPL03970
OUTER    L     6,4(6)              BACK TO PREV SA                      ZPL03980
         BCT   9,EXTFLP                                                 ZPL03990
         B     QUITSCAN                                                 ZPL04000
*                                  STATEMENT NO. FOR OPTIMISER          ZPL04010
PLOPT    L     7,WRD2              PSW ADDR                             ZPL04020
         L     8,44(5)             R3 FROM RB SA                        ZPL04030
         L     15,80(5)            R12 FROM RB                          ZPL04040
         LA    0,3                                                      ZPL04050
         NR    0,15                FULLWORD BOUNDARY ?                  ZPL04060
         BNZ   NONPLI              N. NOT TCA POINTER IN R12            ZPL04070
         L     15,24(15)           -> PL/I S HIGH SAVE AREA             ZPL04080
         LA    15,0(15)            CLEAR TOP BYTE                       ZPL04090
         C     15,=A(SAV)          = OUR SAVE AREA ?                    ZPL04100
         BE    ISPLI               Y THEN WE DO HAVE TCA                ZPL04110
         L     15,4(15)            CHECK IF SAVE A OF SHARED LIB PIRA   ZPL04120
         LA    15,0(15)            CLEAR TOP BYTE                       ZPL04130
         C     15,=A(SAV)          IS THIS SA -> OUR SAVE AREA          ZPL04140
         BNE   NONPLI              N. NOT TCA POINTER IN R12            ZPL04150
*                                                                       ZPL04160
ISPLI    NI    EXTOPT+1,X'0F'                                           ZPL04170
SCANOPT  LA    6,0(6)              CLEAR HI BYTE                        ZPL04180
         TM    0(6),X'02'          DUMMY DSA ?                          ZPL04190
         BO    QUITSCAN            Y                                    ZPL04200
         C     6,=A(SAV)           OUR SAVE AREA ?                      ZPL04210
         BE    QUITSCAN            Y                                    ZPL04220
         TM    0(6),X'80'          DSA ?                                ZPL04230
         BZ    NOTDSA                                                   ZPL04240
         TM    0(6),X'08'          LIB OR BEGIN ?                       ZPL04250
         BZ    OPTSTMT             N                                    ZPL04260
         TM    0(6),X'04'          LIB DSA ?                            ZPL04270
         BO    OPTSTMT             N                                    ZPL04280
NOTDSA   EQU   *                                                        ZPL04290
         L     6,4(6)              NEXT SA                              ZPL04300
         L     7,12(6)             SAVED R14 INSTEAD OF PSW ADDR        ZPL04310
         LA    7,0(7)              CLEAR HIGH BYTE                      ZPL04320
         L     8,32(6)             SAVED R3                             ZPL04330
         BCT   9,SCANOPT                                                ZPL04340
         B     QUITSCAN                                                 ZPL04350
OPTSTMT  TM    1(6),X'04'          STMT NO. TABLE ?                     ZPL04360
         BZ    NOPTSTMT            N                                    ZPL04370
FINDSTMT L     15,4(6)             PREV SA                              ZPL04380
         L     15,16(15)           -> EP OF BLOCK                       ZPL04390
         L     15,8(15)            ->STMT NO. TABLE                     ZPL04400
         S     7,0(15)             OFFSET                               ZPL04410
         BL    NOPTSTMT            -VE OFFSET                           ZPL04420
         C     7,4(15)             OFFSET WITHIN SIZE OF BLOCK ?        ZPL04430
         BH    NOPTSTMT            N                                    ZPL04440
         LA    15,8(15)            -> 1ST SECTION                       ZPL04450
         SR    1,1                                                      ZPL04460
         BCTR  1,0                 DUMMY STMT NO.                       ZPL04470
         L     0,=X'FFFF8000'                                           ZPL04480
         TM    1(6),X'01'          FLAGS 2 VALID ?                      ZPL04490
         BZ    NOTLNNO             N                                    ZPL04500
         TM    118(6),X'04'        LINE NUMBERS, NOT STMT ?             ZPL04510
         BO    FINDLNNO            Y                                    ZPL04520
NOTLNNO  EQU   *                                                        ZPL04530
         NR    0,7                 > X'7FFF' ?                          ZPL04540
         BZ    STLOOP2             Y                                    ZPL04550
         XR    7,0                 REMAINDER IN R7                      ZPL04560
         SRL   0,15                NO. OF SECTIONS IN R0                ZPL04570
STLOOP1  L     15,0(15)            NEXT SECTION                         ZPL04580
         BCT   0,STLOOP1                                                ZPL04590
         LR    1,15                                                     ZPL04600
         BCTR  1,0                                                      ZPL04610
         BCTR  1,0                                                      ZPL04620
         LH    1,0(1)              LAST STMT NO. OF PREV SECTION        ZPL04630
STLOOP2  LA    15,4(15)            NEXT ENTRY                           ZPL04640
         CH    7,0(15)             CF OFFSET                            ZPL04650
         BNH   STMTFND             HIGH OFFSET FOUND                    ZPL04660
         LH    1,2(15)             STMT NO.                             ZPL04670
         B     STLOOP2                                                  ZPL04680
STMTFND  SLA   1,5                 ADD STMT WITHIN LINE BITS            ZPL04690
         ST    1,WRD3                                                   ZPL04700
         B     OPTNAME                                                  ZPL04710
*                                                                       ZPL04720
FINDLNNO NR    0,7                 > X'7FFFF' ?                         ZPL04730
         BNZ   *+10                Y                                    ZPL04740
         LR    0,1                 N. DUMMY STMT NO                     ZPL04750
         B     SCANLNNO                                                 ZPL04760
*                                                                       ZPL04770
         XR    7,0                 R7 IS RMDR OF OFFSET                 ZPL04780
         SRL   0,15                R0 IS NO. OF SECTIONS TO SKIP        ZPL04790
LNLOOP1  LR    1,15                THIS SECTION                         ZPL04800
         L     15,0(15)            NEXT SECTION                         ZPL04810
         BCT   0,LNLOOP1                                                ZPL04820
         SR    1,15                SIZE OF PREV SECTION                 ZPL04830
         LPR   1,1                                                      ZPL04840
         SR    0,0                                                      ZPL04850
         LA    14,6                LENGTH OF ENTRIES                    ZPL04860
         DR    0,14                                                     ZPL04870
         LTR   0,0                 FIND OFFSET BACK TO LAST ENTRY       ZPL04880
         BNZ   *+8                 IN PREV SECTION                      ZPL04890
         LA    0,6                                                      ZPL04900
         LR    1,15                                                     ZPL04910
         SR    1,0                 PREV LINE NUMBER                     ZPL04920
         LH    0,0(1)                                                   ZPL04930
         LH    1,2(1)                                                   ZPL04940
*                                                                       ZPL04950
SCANLNNO LA    15,4(15)            -> 1ST ENTRY                         ZPL04960
*                                                                       ZPL04970
LNLOOP2  CH    7,0(15)                                                  ZPL04980
         BNH   LNNOFND             THIS STMT                            ZPL04990
         LH    0,2(15)             1ST HALF OF LINE NO.                 ZPL05000
         LH    1,4(15)             2ND HALF OF LINE NO.                 ZPL05010
         LA    15,6(15)            NEXT ENTRY                           ZPL05020
         B     LNLOOP2                                                  ZPL05030
*                                                                       ZPL05040
LNNOFND  LA    1,1(1)              INCR STMT NO. ON LINE                ZPL05050
         SLL   1,16                JOIN HALVES OF LINE NUMBER           ZPL05060
         SRDL  0,16                                                     ZPL05070
         ST    1,WRD3                                                   ZPL05080
         B     OPTNAME                                                  ZPL05090
NOPTSTMT SR    0,0                 NO STMT NO. SET DUMMY                ZPL05100
         BCTR  0,0                                                      ZPL05110
         ST    0,WRD3                                                   ZPL05120
OPTNAME  LA    9,100                LOOP COUNT                          ZPL05130
PROCLOOP TM    0(6),X'0C'               PROC ?                          ZPL05140
         BZ    PROCOPT             Y                                    ZPL05150
         L     6,4(6)              NEXT SA                              ZPL05160
         TM    0(6),X'02'          DUMMY SA ?                           ZPL05170
         BO    MAINOPT                                                  ZPL05180
         BCT   9,PROCLOOP                                               ZPL05190
         B     QUITSCAN                                                 ZPL05200
PROCOPT  L     6,4(6)              BACK 1 DSA                           ZPL05210
         TM    0(6),X'02'          DUMMY DSA ?                          ZPL05220
         BZ    *+8                 N                                    ZPL05230
MAINOPT  OI    WRD1+3,X'80'        Y. IND MAIN PROC                     ZPL05240
NAMEOPT  L     15,16(6)            SAVED R15                            ZPL05250
         BCTR  15,0                -> L'NAME                            ZPL05260
         SR    7,7                                                      ZPL05270
         IC    7,0(15)             L'NAME                               ZPL05280
         SR    15,7                -> NAME                              ZPL05290
         BCTR  7,0                                                      ZPL05300
         CH    7,*+10                                                   ZPL05310
         BNH   *+8                                                      ZPL05320
         LA    7,7                 MAX 8 CHARS                          ZPL05330
         MVC   WRD5(8),=CL8' '                                          ZPL05340
         LTR   7,7                 LENGTH NEGATIVE ?                    ZPL05350
         BL    EXTOPT              Y. NO NAME                           ZPL05360
         EX    7,MOVEOPT           MOVE NAME                            ZPL05370
EXTOPT   NOP   EXTOLP              NOP FOR INNER PROC, B FOR OUTER      ZPL05380
         OI    *-3,X'F0'                                                ZPL05390
         MVC   WRD7(8),WRD5        MOVE NAME TO MINOR NAME              ZPL05400
         LA    9,100               LOOP COUNT                           ZPL05410
EXTOLP   TM    0(6),X'02'          DUMMY DSA ?                          ZPL05420
         BO    QUITSCAN            Y                                    ZPL05430
         TM    0(6),X'0C'          N. PROC ?                            ZPL05440
         BNZ   NEXTOPT             N                                    ZPL05450
         C     8,32(6)             Y. SAME STATIC CSECT ?               ZPL05460
         BNE   NEXTOPT                                                  ZPL05470
         L     6,4(6)              Y. NEXT SA                           ZPL05480
         BCT   9,NAMEOPT           GET NAME                             ZPL05490
         B     QUITSCAN                                                 ZPL05500
NEXTOPT  L     6,4(6)              PREV DSA                             ZPL05510
         BCT   9,EXTOLP                                                 ZPL05520
         B     QUITSCAN            GO TO O/P RECORD                     ZPL05530
         SPACE 2                                                        ZPL05540
NONPLI   EQU   *                   HERE IF NOT IN PL/I CODE             ZPL05550
         SR    0,0                                                      ZPL05560
         BCTR  0,0                                                      ZPL05570
         ST    0,WRD3              IND NO STMT NUMBER                   ZPL05580
         MVC   WRD5(8),=CL8'NON-PL/I'                                   ZPL05590
         L     15,28(5)            LOWEST NON-SAVE AREA TYPE RB         ZPL05600
         L     15,12(15)           -> CDE FOT IT                        ZPL05610
         MVC   WRD7(8),8(15)       CALL IT PROC NON-PL/I.NAME           ZPL05620
         SPACE 2                                                        ZPL05630
QUITSCAN EQU   *                                                        ZPL05640
         MVC   WRD1(3),=C'RUN'                                          ZPL05650
         PUT   DCBOUT,BUFFER                                            ZPL05660
         EJECT                                                          ZPL05670
         LH    9,MODSCNB      TRAPS LEFT BEFORE MODULE SCAN             ZPL05680
         BCT   9,NOMODSCN     UNLESS ZERO - NO MODULE SCAN              ZPL05690
         MVC   MODSCNB,MODSCNA  RESET MODULE SCAN COUNT                 ZPL05700
****************** SCAN CDE ENTRIES AND OUTPUT RECORDS FOR              ZPL05710
****                          MODULES IN CORE                           ZPL05720
         MVC   WRD1,=C'LOAD'                                            ZPL05730
         L     2,TCBAD                                                  ZPL05740
         L     3,36(,2)       LLE                                       ZPL05750
         SPACE 3                                                        ZPL05760
LLSCAN   EQU   *              PICK UP MODULES ON LOAD LIST              ZPL05770
         L     4,4(,3)        CDE ADDRESS                               ZPL05780
         BAL   8,STARTCDE     REPORT                                    ZPL05790
         L     3,0(,3)        NEXT LLE                                  ZPL05800
         LTR   3,3            LAST ONE REPORTED=END OF LIST             ZPL05810
         BNZ   LLSCAN         IF NOT CONTINUE SCAN                      ZPL05820
         SPACE 2                                                        ZPL05830
******************* PICK UP MODULES WITH RBS                            ZPL05840
         L     3,0(,2)        RBP FROM TCB                              ZPL05850
RBSCAN   EQU   *                                                        ZPL05860
         TM    10(3),X'C0'    PRB                                       ZPL05870
         BNZ   NEXTRB         NO - DONT LOOK AT CDE                     ZPL05880
         L     4,12(,3)       CDE ADDRESS FROM RB                       ZPL05890
         BAL   8,STARTCDE     REPORT                                    ZPL05900
NEXTRB   EQU   *                                                        ZPL05910
         L     3,28(,3)       NEXT RB ADDRESS                           ZPL05920
         LA    3,0(,3)        CLEAR HO-BYTE                             ZPL05930
         CR    3,2            IS IT TCB                                 ZPL05940
         BNE   RBSCAN         NO - RB - GO CHECK IT                     ZPL05950
         B     MODSCAND       YES - ALL DONE                            ZPL05960
         SPACE 2                                                        ZPL05970
STARTCDE EQU   *                                                        ZPL05980
XLFIND   EQU   *                                                        ZPL05990
***       ON ENTRY  REG 4 POINTS TO CDE                                 ZPL06000
         CLI   16(4),0             NON-MVS USE COUNT ?                  ZPL06010
         BNE   *+12                Y. ASSUME NON-MVS                    ZPL06020
*                                                                       ZPL06030
         TM    28(4),X'04'         MVS. MINOR CDE ?                     ZPL06040
         B     *+8                 GO TO BC                             ZPL06050
*                                                                       ZPL06060
         TM    0(4),X'04'          NON-MVS. MINOR CDE ?                 ZPL06070
         BZ    EXTENT              N. FIND ADDR AND SIZE OF MODULE      ZPL06080
*                                                                       ZPL06090
         L     4,20(,4)       NO - NEXT CDE                             ZPL06100
         LA    4,0(,4)        CLEAR HO BYTE                             ZPL06110
         LTR   4,4            IS THERE ONE                              ZPL06120
         BNZ   XLFIND         YES - CHECK                               ZPL06130
         BR    8              SKIP THIS MOD IF NO XL OR MAJ             ZPL06140
EXTENT   EQU   *                                                        ZPL06150
         L     5,20(,4)       XL ADDR FROM CDE                          ZPL06160
         LA    5,0(5)              CLEAR TOP BUTE                       ZPL06170
         LTR   5,5                 ANY ADDR ?                           ZPL06180
         BCR   8,8                 N. BACK OUT                          ZPL06190
         L     6,4(,5)        NUMBER OF ENTRIES                         ZPL06200
         SLL   6,2            TIMES 4                                   ZPL06210
         LA    6,0(5,6)       TO FIRST LOC -8                           ZPL06220
         MVC   WRD2,8(6)      BEGIN ADDR                                ZPL06230
         SR    7,7                                                      ZPL06240
SIZEADD  EQU   *                                                        ZPL06250
         A     7,8(,5)        LENGTH                                    ZPL06260
         LA    7,0(,7)        CLEAR HI ORDER                            ZPL06270
         LA    5,4(,5)        INCREMENT                                 ZPL06280
         CR    5,6            FINISHED                                  ZPL06290
         BL    SIZEADD        NO - CONTINUE                             ZPL06300
         ST    7,WRD3         YES - STORE TOTAL SIZE                    ZPL06310
         MVC   WRD5(8),8(4)   NAME FROM CDE                             ZPL06320
         PUT   DCBOUT,BUFFER                                            ZPL06330
         BR    8              RETURN TO CALLER (LLSCAN OR RBSCAN)       ZPL06340
NOMODSCN EQU   *                                                        ZPL06350
         STH   9,MODSCNB      RESTORE COUNT BEFORE NEXT MOD SCAN        ZPL06360
MODSCAND EQU   *                                                        ZPL06370
         SPACE 3                                                        ZPL06380
ERRQUIT  EQU   *              COME HERE AFTER PROGRAM CHECK             ZPL06390
         L     4,DUMINTVL                                               ZPL06400
         S     4,TIMELEFT                                               ZPL06410
         A     4,TOTTIME                                                ZPL06420
         ST    4,TOTTIME                                                ZPL06430
         TTIMER CANCEL                                                  ZPL06440
         ST    0,TIMELEFT                                               ZPL06450
         L     0,ADEXIT                                                 ZPL06460
         STIMER    TASK,(0),TUINTVL=TRCINTVL                            ZPL06470
RETURN   EQU   *                                                        ZPL06480
         L     1,PICA                                                   ZPL06490
         SPIE  MF=(E,(1))                                               ZPL06500
         L     13,SAV2+4                                                ZPL06510
         RETURN (14,12),RC=0                                            ZPL06520
         SPACE 2                                                        ZPL06530
MOVEPROC MVC   WRD5(0),5(15)       MOVE F PROC NAME                     ZPL06540
MOVEOPT  MVC   WRD5(0),0(15)       MV OPT PROC NAME                     ZPL06550
         TITLE '    ERROR MESSAGE ROUTINE'                              ZPL06560
*        ABEND 900,DUMP                                                 ZPL06570
ERROR01  EQU   *                                                        ZPL06580
         MVC   WTO+22(2),=C'01'                                         ZPL06590
         B     COMMERR                                                  ZPL06600
ERROR02  EQU   *                                                        ZPL06610
         MVC   WTO+22(2),=C'02'                                         ZPL06620
COMMERR  EQU   *                                                        ZPL06630
         LH    9,ERRLIMIT                                               ZPL06640
         BCT   9,ERRMESS                                                ZPL06650
         B     TERMINAT                                                 ZPL06660
DAVTERM  EQU   *              DO FINAL CLOSE DOWN                       ZPL06670
         L     4,ADAVFLAG                                               ZPL06680
         OI    0(4),X'FF'     SET FLAG TO SAY CLOSE ALREADY DONE        ZPL06690
         MVC   WRD1,=CL4'END'                                           ZPL06700
         L     4,DUMINTVL                                               ZPL06710
         S     4,TIMELEFT                                               ZPL06720
         A     4,TOTTIME                                                ZPL06730
         ST    4,WRD3                                                   ZPL06740
         MVC   WRD4,TIMEIN                                              ZPL06750
         TIME  BIN                                                      ZPL06760
         ST    0,WRD5                                                   ZPL06770
         PUT   DCBOUT,BUFFER                                            ZPL06780
TERMINAT EQU   *                                                        ZPL06790
WTO2     WTO   'EXTRACTION TERMINATED',ROUTCDE=11                       ZPL06800
         MVC   BUFFER(21),WTO2+8                                        ZPL06810
         PUT   DCBOUT,BUFFER                                            ZPL06820
         TTIMER CANCEL                                                  ZPL06830
         CLOSE (DCBOUT)                CLOSE THE ANALYSIS FILE          ZPL06840
         ABEND 666                                                      ZPL06850
ERRMESS  EQU   *                                                        ZPL06860
         STH   9,ERRLIMIT                                               ZPL06870
WTO      WTO   'EXTRACT ERROR 00 ',ROUTCDE=11                           ZPL06880
         MVC   BUFFER(16),WTO+8                                         ZPL06890
         PUT   DCBOUT,BUFFER                                            ZPL06900
         B     ERRQUIT           BETTER LUCK NEXT ROUND                 ZPL06910
DUMEXIT  EQU   *                                                        ZPL06920
         USING *,15                                                     ZPL06930
         ABEND 901,DUMP                                                 ZPL06940
         TITLE '    SPIE EXIT ROUTINE '                                 ZPL06950
SPIEXIT  EQU   *                                                        ZPL06960
******************** SPIE EXIT ROUTINE  ******************************  ZPL06970
         DROP  12                                                       ZPL06980
         BALR  2,0                                                      ZPL06990
         USING *,2                                                      ZPL07000
         ST    13,SAV3+4                                                ZPL07010
         LA    13,SAV3                                                  ZPL07020
         ST    14,SAV3                                                  ZPL07030
         L     15,8(1)                                                  ZPL07040
         LA    15,0(15)                                                 ZPL07050
         S     15,ENTERAD                                               ZPL07060
         ST    15,WRD2                                                  ZPL07070
         UNPK  WRD2(8),WRD2+1(4)   UNPACK                               ZPL07080
         TR    WRD2+1(7),HEX-C'0'  TR TO HEX                            ZPL07090
         MVI   WRD2,C'+'           PLUS                                 ZPL07100
         LTR   15,15               OFFSET -VE ?                         ZPL07110
         BNL   *+8                 N                                    ZPL07120
         MVI   WRD2,C'-'           MINUS                                ZPL07130
         XC    WRD4,WRD4           ZERO WORD 4                          ZPL07140
         MVC   WRD4+3(1),7(1)      MV INTERRUPT CODE                    ZPL07150
         MVC   WRD1,=C'PGCK'                                            ZPL07160
         LH    14,ERRLIMIT                                              ZPL07170
         BCT   14,NOTQUIT                                               ZPL07180
         MVC   8(4,1),TERMADD                                           ZPL07190
         B     RETURN2                                                  ZPL07200
NOTQUIT  EQU   *                                                        ZPL07210
         STH   14,ERRLIMIT                                              ZPL07220
         MVC   8(4,1),ERRQUITA   ADDR OF QUIT TO PIE                    ZPL07230
         PUT   DCBOUT,BUFFER                                            ZPL07240
RETURN2  EQU   *                                                        ZPL07250
         L     14,SAV3                                                  ZPL07260
         L     13,SAV3+4                                                ZPL07270
         BR    14                                                       ZPL07280
         TITLE '    DCB AND CONSTANTS '                                 ZPL07290
DCBOUT   DCB   DSORG=PS,DDNAME=TRACE,RECFM=FBS,MACRF=(PM)               ZPL07300
         EJECT                                                          ZPL07310
LIBRARY  DCB   DSORG=PO,MACRF=R                                         ZPL07320
         EJECT                                                          ZPL07330
         DS    0F                                                       ZPL07340
DUMINTVL DC    X'000A0000'                                              ZPL07350
TIMELEFT DS    F                                                        ZPL07360
TOTTIME  DC    F'0'                                                     ZPL07370
TIMEIN   DS    F                                                        ZPL07380
MASK     DC    F'7'                                                     ZPL07390
MODSCNA  DC    H'40'          EVERY 40 TRAPS, SCAN CDE'S                ZPL07400
MODSCNB  DC    H'0'                                                     ZPL07410
PRBAD    DS    F              ADDR LINKED RB                            ZPL07420
TRCINTVL DC    F'768'              DEFAULT TIME INTERVAL                ZPL07430
TCBAD    DS    F                                                        ZPL07440
SAV      DC    18F'0'                                                   ZPL07450
         DC    X'FDFD'                                                  ZPL07460
ERRLIMIT DC    H'1024'          ERROR RETRY LIMIT                       ZPL07470
SAV2     DS    18F                                                      ZPL07480
SAV3     DS    18F                                                      ZPL07490
COUNT    DC    F'0'                                                     ZPL07500
BLDL     DC    H'1,58'             AREA FOR BLDL                        ZPL07510
NAME     DC    CL8' '                                                   ZPL07520
         DC    CL50' '             TTR AND USER INF                     ZPL07530
OPT      DC    C'O'                O=OPTIMISER, F=PL/1 F                ZPL07540
PICA     DS    F                                                        ZPL07550
CNTLIMIT DC    F'10000'     MAX TRAPS BEFORE STAT VIABLE                ZPL07560
ENTERAD  DC    A(ZPLT)             ADDR(ENTRY POINT)                    ZPL07570
ERRQUITA DC    A(ERRQUIT)                                               ZPL07580
TERMADD  DC    A(TERMINAT)                                              ZPL07590
ADEXIT   DC    A(EXIT)                                                  ZPL07600
ADAVFLAG DC    A(DAVFLAG)                                               ZPL07610
BUFFER   EQU   *                                                        ZPL07620
WRD1     DS    F                                                        ZPL07630
WRD2     DS    F                                                        ZPL07640
WRD3     DS    F                                                        ZPL07650
WRD4     DS    F                                                        ZPL07660
WRD5     DS    F                                                        ZPL07670
WRD6     DS    F                                                        ZPL07680
WRD7     DS    F                                                        ZPL07690
WRD8     DS    F                                                        ZPL07700
HEX      DC    C'0123456789ABCDEF'                                      ZPL07710
*                                                                       ZPL07720
         END                                                            ZPL07730
