         TITLE 'MULT63'
***********************************************************************
*   MULT63       PLI FUNCTION
***********************************************************************
         SPACE
***********************************************************************
*
*  MULT63 MULTIPLIES TWO DOUBLEWORD BINARY FIELDS
*
*  LINKAGE :
*             DCL MULT63  ENTRY EXT RETURNS(CHAR(8));
*             DCL A  CHAR(8),
*                 B  CHAR(8);
*             DCL RESULT  CHAR(8);
*
*             RESULT = MULT63(A,B);
*
*  REGISTER USAGE :
*
*    R1
*    R2
*    R3
*    R4  A PART 1
*    R5  A PART 2
*    R6  B PART 1
*    R7  B PART 2
*    R8  C PART 1
*    R9  C PART 2
*   R11  SIGN FLAG
*   R12  RESERVED
*   R13  BASE
*
*  RESTRICTIONS :
*
*    PLI USE ONLY
*
*    ALL FIELDS MUST BE CHAR(8)
*
**********************************************************************
         EJECT
MULT63   CSECT
         INIT  MULT63
         SPACE
         L     R2,0(R1)                     LOC/DESC SOURCE 1
         TM    0(R1),X'80'                  MUST NOT BE LAST PARM
         BO    A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R2,4(R2)                     CHECK SOURCE LENGTH
         CH    R2,=H'8'                     ABEND IF NOT CHAR(8)
         BNE   A010
         SPACE
         L     R2,4(R1)                     LOC/DESC SOURCE 2
         TM    4(R1),X'80'                  MUST NOT BE LAST PARM
         BO    A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R2,4(R2)                     CHECK SOURCE LENGTH
         CH    R2,=H'8'                     ABEND IF NOT CHAR(8)
         BNE   A010
         SPACE
         L     R2,8(R1)                     LOC/DESC TARGET
         TM    8(R1),X'80'                  MUST BE LAST PARM
         BNO   A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R2,4(R2)                     CHECK TARGET LENGTH
         CH    R2,=H'8'                     ABEND IF NOT CHAR(8)
         BE    A020
         SPACE
A010     EQU   *                            SIGNAL ERROR
         LA    R1,ICB
         L     R15,120(R12)
         BALR  R14,R15
         SPACE
A020     EQU   *
         SPACE
**********************************************************************
         SPACE
         LA    R11,0                   RESET SIGN FLAG
         SPACE
         L     R2,0(R1)                GET FIRST (A)
         L     R2,0(R2)
         LM    R4,R5,0(R2)
         ST    R4,WORK
         TM    WORK,X'80'              NEGATIVE ?
         BZ    A030                    NO - BRANCH
         LA    R11,1(R11)              INCR SIGN FLAG
         X     R5,=X'FFFFFFFF'         MAKE POSITIVE
         AL    R5,=F'1'
         BC    12,A024
         X     R4,=X'FFFFFFFF'
         A     R4,=F'1'
         B     A030
A024     EQU   *
         X     R4,=X'FFFFFFFF'
A030     EQU   *
         SPACE
         L     R2,4(R1)                GET SECOND (B)
         L     R2,0(R2)
         LM    R6,R7,0(R2)
         ST    R6,WORK
         TM    WORK,X'80'              NEGATIVE
         BZ    A050                    NO - BRANCH
         LA    R11,1(R11)              INCR SIGN FLAG
         X     R7,=X'FFFFFFFF'         MAKE POSITIVE
         AL    R7,=F'1'
         BC    12,A044
         X     R6,=X'FFFFFFFF'
         A     R6,=F'1'
         B     A050
A044     EQU   *
         X     R6,=X'FFFFFFFF'
A050     EQU   *
         SPACE
         LA    R8,0                    ZEROISE RESULT
         LR    R9,R8
         SPACE
B100     EQU   *                       LOOP
         ST    R7,WORK                 TEST RH BIT OF B
         TM    WORK+3,X'01'            IF ZERO
         BZ    B300                    THEN NO ACTION
         SPACE
         ALR   R9,R5                   ELSE ADD A TO C
         BC    12,B200
         A     R8,=F'1'
B200     EQU   *
         AR    R8,R4
         SPACE
B300     EQU   *
         SRDA  R6,1                    B: LOSE BIT JUST PROCESSED
         BZ    B400                    ALL '1'S NOW GONE?
         SLDA  R4,1                    A: SHIFT TO NEXT POWER
         B     B100                    LOOP END
         SPACE
B400     EQU   *
         N     R11,=F'1'               TEST SIGN FLAG
         BZ    B500                    POSITIVE - BRANCH
         X     R9,=X'FFFFFFFF'         MAKE NEGATIVE
         AL    R9,=F'1'
         BC    12,A480
         X     R8,=X'FFFFFFFF'
         A     R8,=F'1'
         B     B500
A480     EQU   *
         X     R8,=X'FFFFFFFF'
         SPACE
B500     EQU   *
         L     R2,8(R1)                RETURN RESULT
         L     R2,0(R2)
         STM   R8,R9,0(R2)
         SPACE
         EXIT
         SPACE
         EJECT
***********************************************************************
*                                                                     *
***********************************************************************
         SPACE
WORK     DS    F
         SPACE
ICB      DS    0F
         DC    X'0C'
         DC    AL3(0)
         DC    5F'0'
         SPACE
         LTORG
         SPACE 2
         END
