         TITLE 'IMSSTART'
**********************************************************************
* IMSSTART :
* ALLOWS PL/I EXECUTION TIME PARAMETERS TO BE PASSED TO A
* PL/I (OPTIMISER) PROGRAM RUNNING UNDER IMS.
* THIS MODULE BECOMES THE EP FROM IMS, THEREFORE THE FOLLOWING
* IS REQUIRED IN THE FINAL LINK OF A PGM :  ENTRY IMSSTART
*
* THE ROUTINE WILL SEARCH FOR EXEC OPTIONS AND USER TEXT
* IN THE JCL PARM STRING :
*         PARM='DLI,PGM,PSB,...../EXEC PARMS./.USER PARM DATA'
* EXEC PARMS ARE PROCESSED LEFT TO RIGHT, DUPLICATES ARE NOT DETECTED.
* TO CHANGE DEFAULTS, CHANGE LINE COMMENTED "SET DEFAULTS".
* EXEC PARAMETERS ALLOWED ARE:
*         R,REPORT,SPIE,NOSPIE,STAE,NOSTAE,ISA(NK),ISASIZE(NK)
*
* THE PGM PARM DATA IS POINTED TO BY THE LAST ADDRESS IN AN
* EXTENDED PCB LIST.
*
* NOTE:- A RESTRICTION OF 100 PCB ADDRESSES TO THE APPLICATION PROGRAM
*     IS MADE,(101 ADDRS INCLUDING PARM ADDR);IF MORE ARE REQUIRED
*     THEN AMEND SYMBOL ADDRLIST ACCORDINGLY.
*
* THIS CODE RELIES ON IMS SAVING A POINTER TO THE JCL PARM IN WORD ONE
* OF THE FIRST IMS PROVIDED SAVE AREA.  A FIX IS REQUIRED TO DFSRRA00
* TO PREVENT IMS ANALYSING THE EXTRA PARM DATA.  (TSZU)
*
**********************************************************************
         SPACE 2
IMSSTART CSECT
         EQUATE
         USING *,15
         ST    1,OLDPLIST              PARM LIST OF PCB'S
         STM   14,12,12(13)
         BALR  12,0
         PUSH  USING
         USING *,12
         MVI   OPTFLAG,NOREPORT+SPIE+STAE  SET DEFAULTS
         L     2,16                    CVT
         LR    3,2                     SAVE CVT POINTER
         L     2,0(2)                  OLD/NEW TCBS
         L     2,4(2)                  CURRENT TCB (14/6/82)
         TM    116(3),MFTVS1           VS1/MFT ?
         BNO   A110
         B     A130
         SPACE
A100     ABEND 3001                    SYSTEM NOT RECOGNISED
         SPACE
A110     TM    116(3),MVTVS2           MVT/VS2 ?
         BNO   A100
         SPACE
A130     L     2,112(2)                SA PTR
         L     2,8(2)                  FIRST IMS SA
         L     2,0(2)                  GET PARM STRING PTR
         L     2,0(2)                  POINT AT PARM STRING
         SPACE
         LH    9,0(2)                  GET STRING LEN
         BCTR  9,0                     DECREMENT
         LA    4,2(2)                  SET STRING START
         SPACE
         LA    2,1                     SET INCREMENT
         LA    3,0(4,9)                GET STRING END
A140     CLI   0(4),C'/'               DELIMITER ?
         BE    A150                    YES - BRANCH
         BXLE  4,2,A140                NO - TRY NEXT
         B     A200                    NO PROG PARM FOUND
         SPACE
A150     EQU   *
         CR    R4,R3                   ONLY '/' PRESENT ?
         BE    A200
         LA    4,1(4)                  LOOK FOR ANOTHER /
         ST    4,START1                STORE STRING START
A154     CLI   0(4),C'/'               IS IT /
         BE    A158                    YES - PROG PARM FOUND
         BXLE  4,2,A154                NO - TRY NEXT
         ST    R4,START2
         B     A172                    PLI EXEC PARM ONLY
         SPACE
A158     EQU   *                       MOVE PROG PARM
         ST    R4,START2
         LA    4,1(4)                  POINT AT MY PARM
         SR    3,4                     GET LENGTH FOR EX
         LA    R5,1(R3)
         C     R5,=F'0'                ZERO LENGTH PARM ?
         BE    A159
         EX    3,MOVEPARM              DO MOVE EX
A159     EQU   *
         STH   R5,PARMLEN              STORE LENGTH
         SPACE
         SR    2,2                     MOVE PARM LIST
         LA    3,ADDRLIST              SET LIST START
         L     1,OLDPLIST              OLD PARM LIST
A160     L     4,0(2,1)                GET ADDR
         ST    4,0(2,3)                AND STORE IT
         LTR   4,4                     END OF LIST ?
         BNP   A170                    YES - CLEAR UP
         LA    2,4(2)                  INCR INDEX
         B     A160                    GO BACK AND GET NEXT ONE
         SPACE
A170     EQU   *                       ADD EXTRA ARG TO LIST
         LA    2,0(2,3)                CONCENTRATE ADDR
         NI    0(2),0                  TURN OFF FLAG
         LA    2,4(2)                  POINT AT NEXT ADDR
         LA    3,PARMVEC               GET PARM VECTOR
         ST    3,0(2)                  PUT ITS ADDR IN LIST
         OI    0(2),X'80'              AND SET END OF LIST
         LA    1,ADDRLIST              POINT AT WHOLE LIST
         ST    1,OLDPLIST              RESET POINTER
         SPACE
A172     EQU   *                       PLI EXEC PARMS
         L     R3,START1
         C     R3,START2               NO EXEC PARMS
         BNL   A200
         SPACE
A173     EQU   *
         LR    R4,R3
A174     EQU   *                       LOOK FOR DELIMITER
         CLI   0(R4),C','
         BE    A175
         CLI   0(R4),C'/'
         BE    A175
         C     R4,START2               MAY NOT BE TRAILING / PRESENT
         BNL   A175
         LA    R4,1(R4)                INCR POINTER
         B     A174                    BRANCH BACK
         SPACE
A175     EQU   *
         SR    R4,R3                   GET ITEM LENGTH
         C     R4,=F'0'                IF ZERO GET NEXT
         BNH   A198
         SPACE
         C     R4,=F'6'                LENGTH 6
         BNE   A179
         CLC   0(6,R3),=C'REPORT'
         BNE   A176
         NI    OPTFLAG,X'3F'           SET OFF NOREPORT
         OI    OPTFLAG,REPORT          SET ON REPORT
         B     A198
         SPACE
A176     CLC   0(6,R3),=C'NOSTAE'
         BNE   A177
         NI    OPTFLAG,X'F3'
         OI    OPTFLAG,NOSTAE
         B     A198
         SPACE
A177     EQU   *
         CLC   0(6,R3),=C'NOSPIE'
         BNE   A199
         NI    OPTFLAG,X'CF'
         OI    OPTFLAG,NOSPIE
         B     A198
         SPACE
A179     EQU   *
         C     R4,=F'4'                LENGTH 4
         BNE   A181
         CLC   0(4,R3),=C'STAE'
         BNE   A180
         NI    OPTFLAG,X'F3'
         OI    OPTFLAG,STAE
         B     A198
         SPACE
A180     EQU   *
         CLC   0(4,R3),=C'SPIE'
         BNE   A199
         NI    OPTFLAG,X'CF'
         OI    OPTFLAG,SPIE
         B     A198
         SPACE
A181     EQU   *
         C     R4,=F'1'                LENGTH 1
         BNE   A182
         CLI   0(R3),C'R'
         BNE   A199
         NI    OPTFLAG,X'3F'
         OI    OPTFLAG,REPORT
         B     A198
         SPACE
A182     EQU   *                       OTHER LENGTHS
         LA    R5,4(R3)
         CLC   0(4,R3),=C'ISA('
         BE    A184
         CLC   0(8,R3),=C'ISASIZE('
         BNE   A199
         SPACE
         LA    R5,8(R3)
A184     EQU   *
         LR    R6,R3
         AR    R6,R4
         S     R6,=F'2'
         CLC   0(2,R6),=C'K)'
         BNE   A199
         CR    R5,R6                   IGNORE NULL SPECIFICATION
         BE    A198
         SPACE
         LR    R7,R5                   VERIFY NUMERIC AMOUNT
A186     EQU   *
         CR    R7,R6
         BE    A188
         CLI   0(R7),C'0'
         BL    A199
         CLI   0(R7),C'9'
         BH    A199
         LA    R7,1(R7)
         B     A186
         SPACE
A188     EQU   *                       CALC BYTES AND PUT IN LIST
         SR    R6,R5                   GET LENGTH
         S     R6,=F'1'                ADJUST FOR EX
         EX    R6,PACKISA              PACK
         CVB   R7,WORK8                GET BINARY
         LA    R8,1024                 CONVERT K TO BYTES
         MR    R6,R8
         ST    R7,LENISA               STORE RESULT
         LA    R6,LENISA               SET ADDRESS OF RESULT
         ST    R6,ALENISA
         B     A198                    CARRY ON
         SPACE
A198     EQU   *                       INCR POINTERS
         AR    R3,R4
         C     R3,START2               IF END, GIVE UP
         BNL   A200
         A     R3,=F'1'
         B     A173                    GET NEXT ITEM
         SPACE
A199     EQU   *                       INVALID ITEM
         WTO   'IMSSTART - ERRONEOUS COMPILER OPTION IGNORED'
         B     A198
         SPACE
A200     EQU   *                       END
         LM    14,12,12(13)            RESTORE REGS
         POP   USING
         LA    1,NEWPLIST              PARM LIST FOR PLICALLB
         L     15,=V(PLICALLB)         LOAD EP
         BR    15                      XCTL
         EJECT
***********************************************************************
*                                                                     *
***********************************************************************
         SPACE
NEWPLIST DS    0F
OLDPLIST DS    F                       A(PCB'S + PARM)
ALENISA  DC    A(0)                    A(LENGTH ISA)
AISA     DC    A(0)                    LET PL/I GET ISA
         DC    F'0'                    FOR TASKING-UNUSED
         DC    F'0'                    FOR TASKING-UNUSED
         DC    X'80'                   END OF LIST FLAG
AOPTFLAG DC    AL3(OPTFLAG)            A(OPTIONS FLAGS)
OPTFLAG  DC    X'00000000'             OPTIONS FLAG
LENISA   DC    F'0'                    LENGTH ISA
         SPACE
ADDRLIST DS    101F
PARMVEC  DC    A(PARMLEN)
PARMLEN  DC    H'0'
PARMAREA DS    CL100
         SPACE
MOVEPARM MVC   PARMAREA(0),0(4)
PACKISA  PACK  WORK8,0(1,R5)
         DS    0D
WORK8    DC    X'0000000000000000'
START1   DS    F
START2   DS    F
         SPACE
MFTVS1   EQU   X'20'
MVTVS2   EQU   X'10'
         SPACE
REPORT   EQU   X'80'
NOREPORT EQU   X'40'
SPIE     EQU   X'20'
NOSPIE   EQU   X'10'
STAE     EQU   X'08'
NOSTAE   EQU   X'04'
         EJECT
***********************************************************************
*     LTORG
***********************************************************************
         SPACE
         LTORG
         SPACE 2
         END
