         TITLE 'DIV63'
***********************************************************************
*   DIV63       PLI FUNCTION
***********************************************************************
         SPACE
***********************************************************************
*
*  DIV63 DIVIDES TWO DOUBLEWORD BINARY FIELDS
*
*  LINKAGE :
*             DCL DIV63  ENTRY EXT RETURNS(CHAR(16));
*             DCL A  CHAR(8),
*                 B  CHAR(8);
*             DCL RESULT  CHAR(16);
*
*             RESULT = DIV63(A,B);
*
*             RESULT IS:  RESULT   CHAR(8)
*                         REMINDER CHAR(8)
*
*
*  REGISTER USAGE :
*
*    R1
*    R2
*    R3  SIGN FLAG
*    R4  A PART 1  DIVIDEND, THEN REMAINDER
*    R5  A PART 2
*    R6  B PART 1  DIVISOR
*    R7  B PART 2
*    R8  C PART 1  QUOTIENT
*    R9  C PART 2
*   R10  WORK
*   R11  WORK
*   R12  RESERVED
*   R13  BASE
*
*  RESTRICTIONS :
*
*    PLI USE ONLY
*
*    ALL FIELDS MUST BE CHAR(8) (OR CHAR(16))
*
**********************************************************************
         EJECT
DIV63    CSECT
         INIT  DIV63
         SPACE
         L     R2,0(R1)                     LOC/DESC SOURCE 1
         TM    0(R1),X'80'                  MUST NOT BE LAST PARM
         BO    A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R2,4(R2)                     CHECK SOURCE LENGTH
         CH    R2,=H'8'                     ABEND IF NOT CHAR(8)
         BNE   A010
         SPACE
         L     R2,4(R1)                     LOC/DESC SOURCE 2
         TM    4(R1),X'80'                  MUST NOT BE LAST PARM
         BO    A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R2,4(R2)                     CHECK SOURCE LENGTH
         CH    R2,=H'8'                     ABEND IF NOT CHAR(8)
         BNE   A010
         SPACE
         L     R2,8(R1)                     LOC/DESC TARGET
         TM    8(R1),X'80'                  MUST BE LAST PARM
         BNO   A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R2,4(R2)                     CHECK TARGET LENGTH
         CH    R2,=H'16'                    ABEND IF NOT CHAR(8)
         BE    A020
         SPACE
A010     EQU   *                            SIGNAL ERROR
         LA    R1,ICB
         L     R15,120(R12)
         BALR  R14,R15
         SPACE
A020     EQU   *
         SPACE
**********************************************************************
         SPACE
         LA    R3,0                    RESET SIGN FLAG
         MVI   DIVSIGN,X'00'
         SPACE
         L     R2,0(R1)                GET FIRST (A)
         L     R2,0(R2)
         LM    R4,R5,0(R2)
         STM   R4,R5,DWD1
         TM    DWD1,X'80'              NEGATIVE ?
         BZ    A026                    NO - BRANCH
         LA    R3,1(R3)                INCR SIGN FLAG
         MVI   DIVSIGN,X'FF'
         X     R5,=X'FFFFFFFF'         MAKE POSITIVE
         AL    R5,=F'1'
         BC    12,A024
         X     R4,=X'FFFFFFFF'
         A     R4,=F'1'
         B     A026
A024     EQU   *
         X     R4,=X'FFFFFFFF'
A026     EQU   *
         STM   R4,R5,DWD1
         LA    R10,0                   COUNT NUMBER OF DIGITS
         SRDA  R4,0
         BZ    A030
A028     EQU   *
         LA    R10,1(R10)
         SRDA  R4,1
         BNZ   A028
A030     EQU   *
         LM    R4,R5,DWD1
         SPACE
         L     R2,4(R1)                GET SECOND (B)
         L     R2,0(R2)
         LM    R6,R7,0(R2)
         STM   R6,R7,DWD2
         TM    DWD2,X'80'              NEGATIVE ?
         BZ    A036                    NO - BRANCH
         LA    R3,1(R3)                INCR SIGN FLAG
         X     R7,=X'FFFFFFFF'         MAKE POSITIVE
         AL    R7,=F'1'
         BC    12,A034
         X     R6,=X'FFFFFFFF'
         A     R6,=F'1'
         B     A036
A034     EQU   *
         X     R6,=X'FFFFFFFF'
A036     EQU   *
         STM   R6,R7,DWD2
         LA    R11,0                   COUNT NUMBER OF DIGITS
         SRDA  R6,0
         BZ    A050
A048     EQU   *
         LA    R11,1(R11)
         SRDA  R6,1
         BNZ   A048
A050     EQU   *
         LM    R6,R7,DWD2
         SPACE
         LA    R8,0                    ZEROISE RESULT
         LR    R9,R8
         SPACE
         LTR   R11,R11                 TRAP ZERODIVIDE
         BNZ   A060
         D     R6,=F'0'                FORCE ZERODIVIDE
A060     EQU   *
         CR    R10,R11                 COMPARE LENGTHS
         BL    B500                    NIL RESULT, REMAINDER ONLY
         SR    R10,R11                 NUMBER OF BIT SHIFTS REQD
         STH   R10,A100+2              ALTER SHIFT INSTRUCTION
A100     SLDL  R6,0                    ADJUST DIVISOR
         LA    R10,1(R10)
         SPACE
B100     EQU   *                       LOOP (COUNTER IS R10)
         SLDL  R8,1
         SPACE
         CR    R4,R6                   COMPARE HIGH-ORDER PART
         BH    B106
         BL    B120
         CLR   R5,R7                   COMPARE LOW-ORDER PART
         BL    B120
         SPACE
B106     EQU   *                       SUBTRACTION REQD
         O     R9,=F'1'                SET RESULT BIT
         SLR   R5,R7                   SUB LOW-ORDER PART
         BC    11,B110                 BRANCH IF NO BORROW
         S     R4,=F'1'
B110     EQU   *
         SR    R4,R6                   SUB HIGH-ORDER PART
         SPACE
B120     EQU   *
         SRDL  R6,1                    SHIFT DIVISOR TO NEXT POSITION
         BCT   R10,B100                LOOP END
         SPACE
B400     EQU   *
         N     R3,=F'1'                TEST SIGN FLAG
         BZ    B500                    POSITIVE - BRANCH
         SRDA  R8,0
         BZ    B500                    ZERO - BRANCH
         X     R9,=X'FFFFFFFF'         MAKE QUOTIENT NEGATIVE
         AL    R9,=F'1'
         BC    12,B450
         X     R8,=X'FFFFFFFF'
         A     R8,=F'1'
         B     B500
B450     EQU   *
         X     R8,=X'FFFFFFFF'
         SPACE
B500     EQU   *
         CLI   DIVSIGN,X'00'           TEST FOR NEGATIVE DIVIDEND
         BE    B540                    POSITIVE - BRANCH
         SRDA  R4,0                    TEST FOR ZERO REMAINDER
         BZ    B540                    ZERO - BRANCH
         X     R5,=X'FFFFFFFF'         MAKE REMAINDER NEGATIVE
         AL    R5,=F'1'
         BC    12,B520
         X     R4,=X'FFFFFFFF'
         A     R4,=F'1'
         B     B540
B520     EQU   *
         X     R4,=X'FFFFFFFF'
B540     EQU   *
         SPACE
         L     R2,8(R1)                RETURN RESULT
         L     R2,0(R2)
         STM   R8,R9,0(R2)             STORE QUOTIENT
         STM   R4,R5,8(R2)             STORE REMAINDER
         SPACE
         EXIT
         SPACE
         EJECT
***********************************************************************
*                                                                     *
***********************************************************************
         SPACE
DWD1     DS    D
DWD2     DS    D
WORK     DS    F
         SPACE
ICB      DS    0F
         DC    X'0C'
         DC    AL3(0)
         DC    5F'0'
         SPACE
DIVSIGN  DS    XL1
         SPACE
         LTORG
         SPACE 2
         END
