CAHTIMER TITLE '           P R O G R A M   T I M I N G   U T I L I T Y'    00100
CAHTIMER START                                                             00200
         SPACE                                                             00300
***********************************************************************    00400
*                                                                     *    00500
*  THIS PROGRAM TIMES THE EXECUTION OF A SPECIFIED LOAD MODULE, AND   *    00600
*  PRINTS OUT A HISTOGRAM SHOWING THE FREQUENCY WITH WHICH EACH       *    00700
*  SECTION OF THE MODULE IS EXECUTED.  THE SIZE OF EACH SECTION, THE  *    00800
*  NUMBER OF SECTIONS TO BE CHARTED AND THE OFFSET OF THE FIRST       *    00900
*  SECTION TO BE CHARTED CAN EACH BE PASSED AS A PARAMETER.           *    01000
*                                                                     *    01100
***********************************************************************    01200
         SPACE 2                                                           01300
* USE OF REGISTERS *                                                       01400
R0       EQU   0             SYSTEM & WORK                                 01500
R1       EQU   1             SYSTEM & WORK                                 01600
R2       EQU   2             -> PRB OF ATTACHED TASK                       01700
R3       EQU   3             A(FIRST SECTION) MINUS SECTION SIZE           01800
R4       EQU   4             SECTION SIZE                                  01900
R5       EQU   5             NUMBER OF SECTIONS - 1  (1ST SECTION IS 0)    02000
R6       EQU   6             A(COUNT ARRAY)                                02100
R7       EQU   7             -> TCB OF ATTACHED TASK                       02200
R8       EQU   8                                                           02300
R9       EQU   9             TOTAL TIME                                    02400
RA       EQU   10            PROGRAM BASE                                  02500
RB       EQU   11                                                          02600
RC       EQU   12            -> PARAMETER PASSED                           02700
RD       EQU   13            SAVE AREA                                     02800
RE       EQU   14            SYSTEM & WORK                                 02900
RF       EQU   15            SYSTEM & WORK                                 03000
         EJECT                                                             03100
         STM   RE,RC,12(RD)                                                03200
         LR    RA,RF                   BASED ON REGISTER 10                03300
         USING CAHTIMER,RA                                                 03400
         LA    RE,SAVE                 CHAIN SAVE AREAS                    03500
         ST    RD,4(,RE)                                                   03600
         ST    RE,8(,RD)                                                   03700
         LR    RD,RE                                                       03800
         SPACE                                                             03900
         L     RC,0(R1)                RC -> PARAMETER PASSED              04000
         CHAP  -1                      REDUCE PRTY BY 1 FOR UNIQUENESS     04100
         SPACE 2                                                           04200
*  EXAMINE THE PARAMETER STRING PASSED  *                                  04300
         SPACE                                                             04400
         LH    R1,0(,RC)               PARAMETER LENGTH                    04500
         LTR   R1,R1                                                       04600
         BZ    PARM8                   ERROR - NO NAME PASSED              04700
         LA    RE,NAME                                                     04800
         SPACE                                                             04900
PARM1    DS    0H                                                          05000
         CLI   2(RC),C','                                                  05100
         BE    PARM2                                                       05200
         CLI   2(RC),C' '                                                  05300
         BE    PARM2                                                       05400
         CLI   2(RC),C'/'                                                  05500
         BE    PARM2                                                       05600
         MVC   0(1,RE),2(RC)           MOVE ONE BYTE                       05700
         LA    RC,1(,RC)               MOVE ON                             05800
         LA    RE,1(,RE)                 TO NEXT BYTE                      05900
         BCT   R1,PARM1                                                    06000
         B     PARM8                                                       06100
         SPACE                                                             06200
PARM2    DS    0H                                                          06300
         BCTR  R1,0                                                        06400
         CLC   3(3,RC),=C'LPA'          TEST IF LINK PACK AREA REQD        06500
         BNE   PARM3                    BR IF NOT                          06600
         LA    RC,3(,RC)                MOVE ON                            06700
         SH    R1,=H'3'                   THREE BYTES                      06800
         L     RE,=A(X'580000')         SO IT'S CRUDE ...                  06900
         ST    RE,START                 SET START ADDRESS FOR HISTOGRAM    07000
         LA    RE,X'500'                                                   07100
         ST    RE,SECNO                 SET NUMBER OF SECTIONS             07200
         SPACE                                                             07300
PARM3    DS    0H                                                          07400
*  TEST FOR OTHER PARAMETERS WILL GO IN HERE ********************          07500
         SPACE 2                                                           07600
*  IGNORE EVERYTHING UP TO AND INCLUDING FIRST '/'.                        07700
         SPACE                                                             07800
PARM7    DS    0H                                                          07900
         CLI   2(RC),C'/'                                                  08000
         LA    RC,1(,RC)                                                   08100
         BE    PARM8                                                       08200
         BCT   R1,PARM7                                                    08300
         SPACE                                                             08400
PARM8    DS    0H                                                          08500
         STH   R1,0(RC)                STORE NEW PARAMETER LENGTH          08600
         ST    RC,PARAM                                                    08700
         OI    PARAM,X'80'             INDICATE END OF PARAMETER LIST      08800
         LA    R1,PARAM                R1 -> NEW PARAMETER                 08900
         SPACE                                                             09000
         ATTACH EPLOC=NAME,LPMOD=2,ECB=ECB                                 09100
         SPACE                                                             09200
         LR    R7,R1                    R7 -> SUBTASK TCB                  09300
         ST    R7,SUBTCB                SAVE ADDRESS FOR DETACH            09400
         SPACE 2                                                           09500
DELAY    STIMER WAIT,BINTVL=BINTVL     WAIT FOR THE SPECIFIED TIME         09600
         TM    ECB,X'40'                TEST SUBTASK ECB                   09700
         BO    COMPLETE                 BR IF SUBTASK ENDED                09800
         SPACE                                                             09900
         TM    SETSW,X'80'                                                 10000
         BO    T0                      BR IF INITIALISATION COMPLETE       10100
         SPACE                                                             10200
         L     R2,0(,R7)               R2 -> REQUEST BLOCK                 10300
U0       CLC   0(8,R2),NAME            IS THIS THE RIGHT RB                10400
         BE    U1                      YES                                 10500
         L     R2,28(,R2)              LOOK FOR NEXT RB                    10600
         CR    R2,R7                   COMPARE WITH ADDRESS OF TCB         10700
         BNE   U0                      BR IF GENUINE RB                    10800
         B     DELAY                   WAIT AGAIN                          10900
         SPACE 2                                                           11000
U1       DS    0H                                                          11100
         MVI   SETSW,X'80'             INDICATE INITIALISATION DONE        11200
         L     R3,START                                                    11300
         LTR   R3,R3                    TEST ABSOLUTE START ADDRESS        11400
         BNZ   U3                       BR IF SO                           11500
         L     R3,12(,R2)              R3 = A(LOAD MODULE)                 11600
         LA    R3,0(,R3)               CLEAR TOP BYTE                      11700
         L     RF,36(,R2)              RF = NUMBER OF DOUBLE-WORDS         11800
         SLL   RF,3                         LENGTH OF LOAD MODULE          11900
         SPACE 2                                                           12000
U3       DS    0H                                                          12100
         SPACE                                                             12200
*  CALCULATE THE NUMBER OF SECTIONS TO BE CONSIDERED, THE SIZE OF EACH     12300
*  SECTION AND THE ADDRESS OF THE FIRST SECTION.  THE DEFAULTS ARE:        12400
*  SIZE OF EACH SECTION :     256 BYTES                                    12500
*  ADDRESS OF FIRST SECTION : ADDRESS OF LOAD MODULE                       12600
*  NUMBER OF SECTIONS :       ENOUGH TO COVER LOAD MODULE                  12700
*  TIME BETWEEN INTERRUPTS :  50 MILLISECONDS                              12800
         SPACE                                                             12900
         L     R4,SECSIZE              SIZE OF EACH SECTION                13000
         L     R5,SECNO                NUMBER OF SECTIONS                  13100
         LTR   R5,R5                                                       13200
         BNZ   U2                      BR IF SPECIFIED                     13300
         SPACE                                                             13400
*  CALCULATE DEFAULT NUMBER OF SECTIONS                                    13500
         SPACE                                                             13600
         SR    RE,RE                   (DIVIDE USES REGISTER PAIR)         13700
         AR    RF,R4                                                       13800
         BCTR  RF,0                                                        13900
         DR    RE,R4                                                       14000
         LR    R5,RF                   R5 = NUMBER OF SECTIONS             14100
U2       LA    R0,2(,R5)               2 EXTRA ENTRIES - LOW AND HIGH      14200
         LA    R5,1(,R5)               SECTIONS GO FROM ZERO TO SECNO+1    14300
         SLL   R0,3                    TWO FULLWORDS PER SECTION           14400
         GETMAIN R,LV=(0)                                                  14500
         LR    R6,R1                   R6 -> COUNT ARRAY                   14600
         LR    RE,R1                                                       14700
         LR    RF,R0                   LENGTH FOR MVCL                     14800
         SR    R1,R1                   ZERO LENGTH FOR MVCL                14900
         MVCL  RE,R0                   CLEAR AREA FROM GETMAIN             15000
         SPACE 2                                                           15100
         A     R3,SECOFF               A(FIRST SECTION TO BE COUNTED)      15200
         SR    R3,R4                   SUBTRACT SIZE OF ONE SECTION        15300
         SPACE                                                             15400
*  THIS IS BECAUSE THE FIRST COUNT IN THE TABLE IS USED TO ACCUMULATE      15500
*  ALL OCCURRENCES OF AN ADDRESS BELOW THE SPECIFIED STARTING POINT.       15600
         SPACE 2                                                           15700
T0       DS    0H                                                          15800
         SPACE                                                             15900
*  SEE WHERE THE TASK BEING TIMED HAS GOT TO, AND BUMP THE COUNT FOR       16000
*  THE APPROPRIATE SECTION BY 1.                                           16100
         SPACE                                                             16200
         L     RE,20(,R2)               RE = ADDRESS FROM PSW              16300
         LA    RE,0(,RE)                CLEAR TOP BYTE                     16400
         SR    RE,R3                    RE = OFFSET                        16500
         SRDA  RE,32                    MOVE TO RF AND PROPAGATE SIGN      16600
         DR    RE,R4                   DIVIDE BY SECTION SIZE              16700
         LTR   RF,RF                                                       16800
         BNL   T1                                                          16900
         SR    RF,RF                   IF NEGATIVE, SET TO ZERO            17000
T1       CR    RF,R5                                                       17100
         BNH   T2                                                          17200
         LR    RF,R5                   IF TOO HIGH, SET TO TOP VALUE       17300
T2       DS    0H                      RF CONTAINS SECTOR NUMBER           17400
         SLL   RF,3                    MULTIPLY BY 8                       17500
         L     RE,0(RF,R6)             PICK UP TOTAL COUNT                 17600
         LA    RE,1(,RE)               BUMP BY 1                           17700
         ST    RE,0(RF,R6)             STORE IT BACK                       17800
         SPACE                                                             17900
         L     RE,0(,R7)               RE -> CURRENT REQUEST BLOCK         18000
         TM    28(RE),X'FF'            TEST WAIT BYTE                      18100
         BNZ   DELAY                   BR IF IN WAIT STATE                 18200
         L     RE,4(RF,R6)             PICK UP CPU COUNT                   18300
         LA    RE,1(,RE)                                                   18400
         ST    RE,4(RF,R6)                                                 18500
         B     DELAY                   ROUND WE GO AGAIN                   18600
         SPACE 2                                                           18700
COMPLETE DS    0H                      SUBTASK HAS TERMINATED              18800
         L     RF,4(,RD)                RF -> SYSTEM SAVE AREA             18900
         MVC   16(4,RF),16(R7)         MOVE RETURN CODE TO RF SLOT         19000
         DETACH SUBTCB                                                     19100
         OPEN  (TIMEOUT,OUTPUT)                                            19200
         TM    TIMEOUT+48,X'10'        TEST IF OPEN                        19300
         BZ    FINISH                  GIVE UP IF NOT                      19400
         SPACE 2                                                           19500
*  THE COUNTS ARE TO BE PRINTED OUT AS FIGURES AND AS A HISTOGRAM.         19600
*  THE FORMAT IS: 6 NUMERICS (OFFSET), ONE BLANK, 9 NUMERICS (COUNT),      19700
*  ONE BLANK, UP TO 115 CHARACTERS.  THE CHARACTERS ARE STARS FOR          19800
*  CPU TIME AND PLUS SIGNS FOR WAIT TIME.                                  19900
*  FIND THE HIGHEST COUNT.  THIS CORRESPONDS TO 115 STARS.  WORK OUT       20000
*  THE CONVERSION FACTOR.                                                  20100
         SPACE                                                             20200
         LR    RF,R5                   NUMBER OF SECTIONS LESS 1           20300
         BCTR  RF,0                    LESS ANOTHER ONE                    20400
         LA    RE,8(,R6)               RE -> FIRST COUNT AFTER LOWS        20500
         SR    R3,R3                                                       20600
         SPACE                                                             20700
C1       L     R0,0(,RE)               PICK UP EACH COUNT IN TURN          20800
         CR    R3,R0                   COMPARE HIGHEST-SO-FAR WITH IT      20900
         BNL   C2                                                          21000
         LR    R3,R0                   UPDATE HIGHEST-SO-FAR IF REQD       21100
C2       LA    RE,8(,RE)               MOVE ON TO NEXT COUNT               21200
         BCT   RF,C1                   LOOP BACK IF NOT FINISHED           21300
         SPACE                                                             21400
         LA    R3,114(,R3)             BUMP BY NO OF STARS MINUS 1         21500
         SR    R2,R2                   (DIVIDE USES REGISTER PAIR)         21600
         D     R2,=F'115'              R3 = AMOUNT TO DIVIDE COUNTS BY     21700
         PUT   TIMEOUT,STARTMSG                                            21800
         PUT   TIMEOUT,HDR1                                                21900
         PUT   TIMEOUT,HDR2                                                22000
         L     R2,SECOFF               OFFSET OF FIRST SECTION             22100
         A     R2,START                   OR ABSOLUTE ADDRESS              22200
         L     R9,0(,R6)               LOW COUNT                           22300
         CVD   R9,DOUBLEWD                                                 22400
         ED    COUNT,DOUBLEWD+3        CONVERT COUNT TO PRINTABLE          22500
         PUT   TIMEOUT,LINE                                                22600
         SPACE                                                             22700
         LA    R6,8(,R6)               MOVE ON TO NEXT PAIR OF COUNTS      22800
         SPACE                                                             22900
C4       DS    0H                                                          23000
         L     RF,0(,R6)               COUNT                               23100
         LTR   RF,RF                                                       23200
         BZ    C8                       BR IF COUNT IS ZERO                23300
         AR    R9,RF                   BUMP TOTAL COUNT                    23400
         CVD   RF,DOUBLEWD                                                 23500
         MVC   COUNT,PATTERN           MOVE EDIT PATTERN ACROSS            23600
         ED    COUNT,DOUBLEWD+3        CONVERT COUNT TO PRINTABLE          23700
         SR    RE,RE                                                       23800
         DR    RE,R3                   DIVIDE BY CONVERSION FACTOR         23900
         LR    R1,RF                                                       24000
         SPACE                                                             24100
*** CONVERT HEX TO PRINTABLE ***                                           24200
         SPACE                                                             24300
         LR    RE,R2                   OFFSET OF THIS SECTION              24400
         LA    RC,6                    COUNT FOR BCT LOOP                  24500
C5       DS    0H                                                          24600
         SRDL  RE,4                    SHIFT HALF-BYTE TO RF               24700
         SRL   RF,28                   SHIFT THIS DOWN TO THE BOTTOM       24800
         IC    RF,TRTAB(RF)            CONVERT TO PRINTABLE CHARACTER      24900
         STC   RF,DATA-1(RC)           STORE IN PRINT LINE                 25000
         BCT   RC,C5                   LOOP BACK                           25100
         SPACE                                                             25200
         LA    R1,22(,R1)              ADD LENGTH OF RECORD BEFORE *'S     25300
         CH    R5,=H'1'                                                    25400
         BNE   C6                      BR IF NOT LAST LINE                 25500
         MVC   ASA(7),=CL7'0HIGH'      LAST LINE :  HIGH COUNT             25600
         LA    R1,21                                                       25700
C6       STH   R1,LINE                 LENGTH INTO RECORD                  25800
         MVI   HIST,C'+'                                                   25900
         MVC   HIST+1(114),HIST        FILL HISTOGRAM WITH PLUS SIGNS      26000
         L     RF,4(,R6)               CPU COUNT                           26100
         SR    RE,RE                                                       26200
         DR    RE,R3                   DIVIDE BY CONVERSION FACTOR         26300
         LTR   RF,RF                                                       26400
         BZ    C7                      BR IF NO CPU TIME (ALL WAIT)        26500
         MVI   HIST,C'*'                                                   26600
         BCTR  RF,0                                                        26700
         LTR   RF,RF                                                       26800
         BZ    C7                      BR IF ONLY ONE STAR REQUIRED        26900
         BCTR  RF,0                    REDUCE BY 1 FOR EXECUTE             27000
         EX    RF,MOVESTAR             PROPAGATE STAR THROUGH HISTOGRAM    27100
C7       DS    0H                                                          27200
         PUT   TIMEOUT,LINE            OUTPUT THE LINE                     27300
         MVI   ASA,C' '                                                    27400
         SPACE                                                             27500
C8       LA    R6,8(,R6)               MOVE ON TO NEXT COUNT               27600
         AR    R2,R4                   OFFSET OF NEXT SECTION              27700
         BCT   R5,C4                   LOOP BACK IF MORE TO COME           27800
         SPACE 2                                                           27900
         CVD   R9,DOUBLEWD                                                 28000
         ED    PATTERN,DOUBLEWD+2      CONVERT TOTAL COUNT TO PRINTABLE    28100
         PUT   TIMEOUT,ENDMSG                                              28200
         SPACE                                                             28300
         CLOSE TIMEOUT                                                     28400
         SPACE                                                             28500
FINISH   DS    0H                                                          28600
         SPACE                                                             28700
*  PASS BACK RETURN CODE OR ABEND TO OS.                                   28800
*  I DON'T KNOW HOW TO TELL WHETHER THE ECB CONTAINS A RETURN CODE OR A    28900
*  COMPLETION CODE.  IF THE CODE IS GREATER THAN 4095, ASSUME ABEND.       29000
         SPACE                                                             29100
         L     RD,4(,RD)                                                   29200
         LM    RE,RC,12(RD)                                                29300
         LA    R1,4095                                                     29400
         CR    RF,R1                   COMPARE CODE WITH X'FFF'            29500
         BNHR  RE                      IF NOT HIGH, RETURN CORRECT CODE    29600
         LA    R1,0(,RF)               CLEAR FLAG BYTE                     29700
         ABEND (1)                     PASS BACK ABEND TO OS               29800
         SPACE 5                                                           29900
MOVESTAR MVC   HIST+1(0),HIST                                              30000
         EJECT                                                             30100
TIMEOUT  DCB   DDNAME=SYSPRINT,MACRF=PM,RECFM=VBA,                     *   30200
               LRECL=137,BLKSIZE=1374,DSORG=PS                             30300
         SPACE 2                                                           30400
DOUBLEWD DC    D'0'                                                        30500
ECB      DC    F'0'                     ECB FOR SUBTASK                    30600
SUBTCB   DC    F'0'                     ADDRESS OF TCB FOR SUBTASK         30700
PARAM    DC    F'0'                    A(PARM FOR SUBTASK)                 30800
SAVE     DC    18F'0'                  SAVE AREA                           30900
START    DC    F'0'                     ABSOLUTE ADDRESS FOR HISTOGRAM     31000
SECSIZE  DC    F'256'                  SIZE OF EACH SECTION                31100
SECOFF   DC    F'0'                    OFFSET OF FIRST SECTION             31200
SECNO    DC    F'0'                    NUMBER OF SECTIONS                  31300
BINTVL   DC    F'5'                    TIME BETWEEN INTERRUPTS (100THS)    31400
         SPACE                                                             31500
STARTMSG DC    AL2(SEND-STARTMSG,0)                                        31600
         DC    C'1* * * * * *   P R O G R A M   T I M I N G  '             31700
         DC    C' U T I L I T Y   C A H T I M E R   * * * * * *'           31800
SEND     DS    0C                                                          31900
         SPACE                                                             32000
HDR1     DC    AL2(H1END-HDR1,0)                                           32100
         DC    C'0TIMINGS FOR PROGRAM '                                    32200
NAME     DC    CL8' '                  NAME OF LOAD MODULE BEING TIMED     32300
H1END    DS    0C                                                          32400
         SPACE                                                             32500
HDR2     DC    AL2(HEND-HDR2,0)                                            32600
         DC    C'-OFFSET     COUNT HISTOGRAM    (*** CPU TIME ***,  '      32700
         DC    C'+++ WAIT TIME +++)'                                       32800
HEND     DS    0C                                                          32900
         SPACE                                                             33000
ENDMSG   DC    AL2(EEND-ENDMSG,0)                                          33100
         DC    C'-****** END OF RUN ******   TOTAL COUNT :'                33200
PATTERN  DC    X'402020202020202020202120'                                 33300
         DC    C' ******'                                                  33400
EEND     DS    0C                                                          33500
         SPACE                                                             33600
         DS    0H                                                          33700
LINE     DC    AL2(21,0)                                                   33800
ASA      DC    C'0'                                                        33900
DATA     DC    CL6'LOW'                                                    34000
COUNT    DC    X'40202020202020202120'                                     34100
         DC    C' '                                                        34200
HIST     DC    CL115' '                HISTOGRAM                           34300
SETSW    DC    X'00'                   SET WHEN INITIALISATION COMPLETE    34400
TRTAB    DC    C'0123456789ABCDEF'                                         34500
         END                                                               34600
