         TITLE 'ADD63'
***********************************************************************
*   ADD63       PLI FUNCTION
***********************************************************************
         SPACE
**********************************************************************
*
*  ADD63 ADDS TWO DOUBLEWORD BINARY FIELDS
*
*  LINKAGE :
*             DCL ADD63   ENTRY EXT RETURNS(CHAR(8));
*             DCL SOURCE1 CHAR(8),
*                 SOURCE2 CHAR(8);
*             DCL TARGET  CHAR(8);
*
*             TARGET = ADD63(SOURCE1,SOURCE2);
*
*  REGISTER USAGE :
*
*    R1
*    R2
*    R4
*    R6   SOURCE1/TARGET PART1
*    R7   SOURCE1/TARGET PART2
*   R12   RESERVED
*
*  RESTRICTIONS :
*
*    PLI USE ONLY
*
*    ALL FIELDS MUST BE CHAR(8)
*
**********************************************************************
         EJECT
         PRINT NOGEN
ADD63    CSECT
         INIT  ADD63
         SPACE
         L     R2,0(R1)                     LOC/DESC SOURCE 1
         TM    0(R1),X'80'                  MUST NOT BE LAST PARM
         BO    A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R4,4(R2)                     CHECK SOURCE LENGTH
         CH    R4,=H'8'                     ABEND IF NOT CHAR(8)
         BNE   A010
         SPACE
         L     R2,4(R1)                     LOC/DESC SOURCE 2
         TM    4(R1),X'80'                  MUST NOT BE LAST PARM
         BO    A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R4,4(R2)                     CHECK SOURCE LENGTH
         CH    R4,=H'8'                     ABEND IF NOT CHAR(8)
         BNE   A010
         SPACE
         L     R2,8(R1)                     LOC/DESC TARGET
         TM    8(R1),X'80'                  MUST BE LAST PARM
         BNO   A010
         TM    6(R2),X'80'                  DISALLOW VARYING LENGTH
         BO    A010
         LH    R4,4(R2)                     CHECK TARGET LENGTH
         CH    R4,=H'8'                     ABEND IF NOT CHAR(8)
         BE    A020
         SPACE
A010     EQU   *                            SIGNAL ERROR
         LA    R1,ICB
         L     R15,120(R12)
         BALR  R14,R15
         SPACE
A020     EQU   *
         L     R2,0(R1)                     GET ADDRESS SOURCE
         L     R3,0(R2)
         LM    R6,R7,0(R3)                  LOAD SOURCE
         L     R2,4(R1)
         L     R3,0(R2)
         SPACE
**********************************************************************
         SPACE
         AL    R7,4(R3)                     ADD LOW PART
         BC    12,A030                      BRANCH IF NO CARRY
         A     R6,=F'1'
A030     EQU   *
         A     R6,0(R3)                     ADD HIGH PART
         SPACE
***********************************************************************
         SPACE
         L     R2,8(R1)
         L     R3,0(R2)
         STM   R6,R7,0(R3)                  RETURN RESULT
         SPACE
         EXIT
         EJECT
***********************************************************************
*    WORKAREAS  ETC                                                   *
***********************************************************************
         SPACE
ICB      DS    0F
         DC    X'0C'
         DC    AL3(0)
         DC    5F'0'
         SPACE
         LTORG
         SPACE 2
         END
